/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.examples.xchange;

import com.xeiam.xchange.Exchange;
import com.xeiam.xchange.ExchangeFactory;
import com.xeiam.xchange.service.streaming.ExchangeEvent;
import com.xeiam.xchange.service.streaming.StreamingExchangeService;
import java.util.concurrent.TimeUnit;
import org.oxerr.huobi.xchange.HuobiExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class HuobiSocketIOServiceDemo {
    private static final Logger log = LoggerFactory.getLogger(HuobiSocketIOServiceDemo.class);

    public static void main(String[] args) throws InterruptedException {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Exchange exchange = ExchangeFactory.INSTANCE.createExchange(HuobiExchange.class.getName());
        final StreamingExchangeService streamingExchangeService = exchange.getStreamingExchangeService(null);
        Thread consumer = new Thread("consumer"){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    try {
                        ExchangeEvent event = streamingExchangeService.getNextEvent();
                        log.info("status: {}, type: {}, data: {}, payload: {}", new Object[]{streamingExchangeService.getWebSocketStatus(), event.getEventType(), event.getData(), event.getPayload()});
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                    }
                }
            }
        };
        consumer.start();
        log.info("Consumer started.");
        streamingExchangeService.connect();
        TimeUnit.MINUTES.sleep(1L);
        streamingExchangeService.disconnect();
        consumer.interrupt();
        log.info("Consumer interrupted.");
    }
}

