/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.credentials;

import java.nio.charset.StandardCharsets;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.util.CommonHelper;

public class KerberosCredentials
extends Credentials {
    private byte[] kerberosTicket;
    private static final long serialVersionUID = -4264156105410684508L;

    public KerberosCredentials(byte[] kerberosTicket, String clientName) {
        this.kerberosTicket = (byte[])kerberosTicket.clone();
        this.setClientName(clientName);
    }

    public byte[] getKerberosTicket() {
        return (byte[])this.kerberosTicket.clone();
    }

    public String getKerberosTicketAsString() {
        return this.getTicketAsString(this.kerberosTicket);
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"token", this.kerberosTicket, "clientName", this.getClientName()});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KerberosCredentials that = (KerberosCredentials)((Object)o);
        return !(this.kerberosTicket == null ? that.kerberosTicket != null : !this.getTicketAsString(this.kerberosTicket).equals(this.getTicketAsString(that.kerberosTicket)));
    }

    public int hashCode() {
        return this.kerberosTicket != null ? this.getTicketAsString(this.kerberosTicket).hashCode() : 0;
    }

    private String getTicketAsString(byte[] kerberosTicket) {
        return new String(kerberosTicket, StandardCharsets.UTF_8);
    }
}

