/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.credentials.authenticator;

import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableWebObject;
import org.pac4j.kerberos.credentials.KerberosCredentials;
import org.pac4j.kerberos.credentials.authenticator.KerberosTicketValidation;
import org.pac4j.kerberos.credentials.authenticator.KerberosTicketValidator;
import org.pac4j.kerberos.profile.KerberosProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthenticator
extends InitializableWebObject
implements Authenticator<KerberosCredentials> {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private KerberosTicketValidator ticketValidator;

    public KerberosAuthenticator() {
    }

    public KerberosAuthenticator(KerberosTicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public void validate(KerberosCredentials credentials, WebContext context) throws CredentialsException {
        this.init(context);
        this.logger.trace("Try to validate Kerberos Token:" + credentials.getKerberosTicketAsString());
        KerberosTicketValidation ticketValidation = this.ticketValidator.validateTicket(credentials.getKerberosTicket());
        this.logger.debug("Kerberos Token validated");
        String subject = ticketValidation.username();
        this.logger.debug("Succesfully validated " + subject);
        KerberosProfile profile = new KerberosProfile();
        profile.setId(subject);
        profile.gssContext = ticketValidation.getGssContext();
        credentials.setUserProfile(profile);
    }

    protected void internalInit(WebContext context) {
        CommonHelper.assertNotNull((String)"ticketValidator", (Object)this.ticketValidator);
    }

    public KerberosTicketValidator getTicketValidator() {
        return this.ticketValidator;
    }

    public void setTicketValidator(KerberosTicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }
}

