/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.credentials.authenticator;

import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSContext;

public class KerberosTicketValidation {
    private final String username;
    private final byte[] responseToken;
    private final GSSContext gssContext;
    private final String servicePrincipal;

    public KerberosTicketValidation(String username, String servicePrincipal, byte[] responseToken, GSSContext gssContext) {
        this.username = username;
        this.servicePrincipal = servicePrincipal;
        this.responseToken = (byte[])(responseToken != null ? (byte[])responseToken.clone() : null);
        this.gssContext = gssContext;
    }

    public String username() {
        return this.username;
    }

    public byte[] responseToken() {
        return (byte[])this.responseToken.clone();
    }

    public GSSContext getGssContext() {
        return this.gssContext;
    }

    public Subject subject() {
        HashSet<KerberosPrincipal> princs = new HashSet<KerberosPrincipal>();
        princs.add(new KerberosPrincipal(this.servicePrincipal));
        return new Subject(false, princs, new HashSet(), new HashSet());
    }
}

