/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.kerberos.client.indirect;

import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.exception.http.UnauthorizedAction;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.kerberos.credentials.KerberosCredentials;
import org.pac4j.kerberos.credentials.extractor.KerberosExtractor;

public class IndirectKerberosClient
extends IndirectClient<KerberosCredentials> {
    public IndirectKerberosClient() {
    }

    public IndirectKerberosClient(Authenticator authenticator) {
        this.defaultAuthenticator(authenticator);
    }

    public IndirectKerberosClient(Authenticator authenticator, ProfileCreator<KerberosCredentials> profileCreator) {
        this.defaultAuthenticator(authenticator);
        this.defaultProfileCreator(profileCreator);
    }

    protected void clientInit() {
        this.defaultRedirectionActionBuilder(webContext -> Optional.of(RedirectionActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)this.computeFinalCallbackUrl(webContext))));
        this.defaultCredentialsExtractor(new KerberosExtractor());
    }

    protected Optional<KerberosCredentials> retrieveCredentials(WebContext context) {
        Optional credentials;
        CommonHelper.assertNotNull((String)"credentialsExtractor", (Object)this.getCredentialsExtractor());
        CommonHelper.assertNotNull((String)"authenticator", (Object)this.getAuthenticator());
        context.setResponseHeader("WWW-Authenticate", "Negotiate");
        try {
            credentials = this.getCredentialsExtractor().extract(context);
            this.logger.debug("kerberos credentials : {}", (Object)credentials);
            if (!credentials.isPresent()) {
                throw UnauthorizedAction.INSTANCE;
            }
            this.getAuthenticator().validate((Credentials)((KerberosCredentials)((Object)credentials.get())), context);
        }
        catch (CredentialsException e) {
            throw UnauthorizedAction.INSTANCE;
        }
        return credentials;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"callbackUrl", this.callbackUrl, "name", this.getName(), "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

