/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Extensions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml.saml2.core.impl.RequestedAuthnContextBuilder;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.profile.api.SAML2ObjectBuilder;
import org.pac4j.saml.util.Configuration;
import org.pac4j.saml.util.SAML2Utils;

public class SAML2AuthnRequestBuilder
implements SAML2ObjectBuilder<AuthnRequest> {
    private final boolean forceAuth;
    private final boolean passive;
    private final AuthnContextComparisonTypeEnumeration comparisonType;
    private String bindingType;
    private String authnContextClassRef;
    private String nameIdPolicyFormat;
    private boolean useNameQualifier;
    private int issueInstantSkewSeconds = 0;
    private final int attributeConsumingServiceIndex;
    private final int assertionConsumerServiceIndex;
    private final String providerName;
    private final Supplier<List<XSAny>> extensions;
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public SAML2AuthnRequestBuilder(SAML2Configuration cfg) {
        this.forceAuth = cfg.isForceAuth();
        this.comparisonType = this.getComparisonTypeEnumFromString(cfg.getComparisonType());
        this.bindingType = cfg.getAuthnRequestBindingType();
        this.authnContextClassRef = cfg.getAuthnContextClassRef();
        this.nameIdPolicyFormat = cfg.getNameIdPolicyFormat();
        this.passive = cfg.isPassive();
        this.attributeConsumingServiceIndex = cfg.getAttributeConsumingServiceIndex();
        this.assertionConsumerServiceIndex = cfg.getAssertionConsumerServiceIndex();
        this.providerName = cfg.getProviderName();
        this.extensions = cfg.getAuthnRequestExtensions();
        this.useNameQualifier = cfg.isUseNameQualifier();
    }

    @Override
    public AuthnRequest build(SAML2MessageContext context) {
        SingleSignOnService ssoService = context.getIDPSingleSignOnService(this.bindingType);
        String idx = this.assertionConsumerServiceIndex > 0 ? String.valueOf(this.assertionConsumerServiceIndex) : null;
        AssertionConsumerService assertionConsumerService = context.getSPAssertionConsumerService(idx);
        return this.buildAuthnRequest(context, assertionConsumerService, ssoService);
    }

    protected final AuthnRequest buildAuthnRequest(SAML2MessageContext context, AssertionConsumerService assertionConsumerService, SingleSignOnService ssoService) {
        SAMLObjectBuilder builder = (SAMLObjectBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest request = (AuthnRequest)builder.buildObject();
        if (this.comparisonType != null) {
            RequestedAuthnContext authnContext = new RequestedAuthnContextBuilder().buildObject();
            authnContext.setComparison(this.comparisonType);
            if (this.authnContextClassRef != null) {
                AuthnContextClassRef classRef = new AuthnContextClassRefBuilder().buildObject();
                classRef.setAuthnContextClassRef(this.authnContextClassRef);
                authnContext.getAuthnContextClassRefs().add(classRef);
            }
            request.setRequestedAuthnContext(authnContext);
        }
        SAMLSelfEntityContext selfContext = context.getSAMLSelfEntityContext();
        request.setID(SAML2Utils.generateID());
        request.setIssuer(this.getIssuer(selfContext.getEntityId()));
        request.setIssueInstant(DateTime.now((DateTimeZone)DateTimeZone.UTC).plusSeconds(this.issueInstantSkewSeconds));
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIsPassive(Boolean.valueOf(this.passive));
        request.setForceAuthn(Boolean.valueOf(this.forceAuth));
        request.setProviderName(this.providerName);
        if (this.nameIdPolicyFormat != null) {
            NameIDPolicy nameIdPolicy = new NameIDPolicyBuilder().buildObject();
            nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
            nameIdPolicy.setFormat(this.nameIdPolicyFormat);
            request.setNameIDPolicy(nameIdPolicy);
        }
        request.setDestination(ssoService.getLocation());
        if (this.assertionConsumerServiceIndex >= 0) {
            request.setAssertionConsumerServiceIndex(Integer.valueOf(this.assertionConsumerServiceIndex));
        } else {
            request.setAssertionConsumerServiceURL(assertionConsumerService.getLocation());
        }
        request.setProtocolBinding(assertionConsumerService.getBinding());
        if (this.attributeConsumingServiceIndex >= 0) {
            request.setAttributeConsumingServiceIndex(Integer.valueOf(this.attributeConsumingServiceIndex));
        }
        if (this.extensions != null) {
            Extensions extensionsElem = (Extensions)((SAMLObjectBuilder)this.builderFactory.getBuilder(Extensions.DEFAULT_ELEMENT_NAME)).buildObject();
            extensionsElem.getUnknownXMLObjects().addAll((Collection)this.extensions.get());
            request.setExtensions(extensionsElem);
        }
        return request;
    }

    protected final Issuer getIssuer(String spEntityId) {
        SAMLObjectBuilder issuerBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(spEntityId);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        if (this.useNameQualifier) {
            issuer.setNameQualifier(spEntityId);
        }
        return issuer;
    }

    protected final AuthnContextComparisonTypeEnumeration getComparisonTypeEnumFromString(String comparisonType) {
        if ("exact".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.EXACT;
        }
        if ("minimum".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MINIMUM;
        }
        if ("maximum".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.MAXIMUM;
        }
        if ("better".equalsIgnoreCase(comparisonType)) {
            return AuthnContextComparisonTypeEnumeration.BETTER;
        }
        return null;
    }

    public void setIssueInstantSkewSeconds(int issueInstantSkewSeconds) {
        this.issueInstantSkewSeconds = issueInstantSkewSeconds;
    }
}

