/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.J2ENopHttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class LogoutController {
    private LogoutLogic<Object, J2EContext> logoutLogic = new DefaultLogoutLogic();
    @Value(value="${pac4j.logout.defaultUrl:#{null}}")
    private String defaultUrl;
    @Value(value="${pac4j.logout.logoutUrlPattern:#{null}}")
    private String logoutUrlPattern;
    @Value(value="${pac4j.logout.localLogout:#{null}}")
    private Boolean localLogout;
    @Value(value="${pac4j.logout.destroySession:#{null}}")
    private Boolean destroySession;
    @Value(value="${pac4j.logout.centralLogout:#{null}}")
    private Boolean centralLogout;
    @Autowired
    private Config config;

    @RequestMapping(value={"/logout"})
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        CommonHelper.assertNotNull((String)"logoutLogic", this.logoutLogic);
        CommonHelper.assertNotNull((String)"config", (Object)this.config);
        J2EContext context = new J2EContext(request, response, this.config.getSessionStore());
        this.logoutLogic.perform((WebContext)context, this.config, (HttpActionAdapter)J2ENopHttpActionAdapter.INSTANCE, this.defaultUrl, this.logoutUrlPattern, this.localLogout, this.destroySession, this.centralLogout);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }

    public LogoutLogic<Object, J2EContext> getLogoutLogic() {
        return this.logoutLogic;
    }

    public void setLogoutLogic(LogoutLogic<Object, J2EContext> logoutLogic) {
        this.logoutLogic = logoutLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Boolean getLocalLogout() {
        return this.localLogout;
    }

    public void setLocalLogout(Boolean localLogout) {
        this.localLogout = localLogout;
    }

    public Boolean getCentralLogout() {
        return this.centralLogout;
    }

    public void setCentralLogout(Boolean centralLogout) {
        this.centralLogout = centralLogout;
    }

    public Boolean getDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(Boolean destroySession) {
        this.destroySession = destroySession;
    }
}

