package org.openstack4j.openstack.identity.domain.v3;

import java.util.Map;

import org.openstack4j.model.identity.builder.v3.PolicyBuilder;
import org.openstack4j.model.identity.v3.Policy;

import com.google.common.base.Objects;

public class KeystonePolicy implements Policy {

    private static final long serialVersionUID = 1L;
    private String id;
    private String type;
    private Map<String, String> links;
    private Map<String, String> blob;

    /**
     * @return the policy builder
     */
    public static PolicyBuilder builder() {
        return new PolicyConcreteBuilder();
    }

    @Override
    public PolicyBuilder toBuilder() {
        return new PolicyConcreteBuilder(this);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getId() {
        return id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getType() {
        return type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<String, String> getBlob() {
        return blob;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Map<String, String> getLinks() {
        return links;
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        return Objects.toStringHelper(this).omitNullValues()
                .add("id", id)
                .add("type", type)
                .add("blob", blob)
                .add("links", links)
                .toString();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        return Objects.hashCode(id, type, blob, links);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null || getClass() != obj.getClass())
            return false;
        KeystonePolicy that = KeystonePolicy.class.cast(obj);
        return Objects.equal(this.id, that.id)
                && Objects.equal(this.type, that.type)
                && Objects.equal(this.blob, that.blob)
                && Objects.equal(this.links, that.links);
    }

    public static class PolicyConcreteBuilder implements PolicyBuilder {

        KeystonePolicy model;

        PolicyConcreteBuilder() {
            this(new KeystonePolicy());
        }

        PolicyConcreteBuilder(KeystonePolicy model) {
            this.model = model;
        }

        @Override
        public Policy build() {
            return model;
        }

        @Override
        public PolicyBuilder from(Policy in) {
            if (in != null)
                this.model = (KeystonePolicy) in;
            return this;
        }

        @Override
        public PolicyBuilder id(String id) {
            model.id = id;
            return this;
        }

        @Override
        public PolicyBuilder type(String type) {
            model.type = type;
            return this;
        }

        @Override
        public PolicyBuilder blob(Map<String, String> blob) {
            model.blob = blob;
            return this;
        }

        @Override
        public PolicyBuilder links(Map<String, String> links) {
            model.links = links;
            return this;
        }

    }

}
