/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.http;

import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.openstack4j.connectors.http.HttpResponseImpl;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.core.transport.functions.EndpointURIFromRequestFunction;
import org.openstack4j.openstack.logging.Logger;
import org.openstack4j.openstack.logging.LoggerFactory;

public final class HttpCommand<R> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpCommand.class);
    private HttpRequest<R> request;
    private URL connectionUrl;
    private HttpURLConnection connection;
    private int retries;

    private HttpCommand(HttpRequest<R> request) {
        this.request = request;
    }

    public static <R> HttpCommand<R> create(HttpRequest<R> request) {
        HttpCommand<R> command = new HttpCommand<R>(request);
        super.initialize();
        return command;
    }

    private void initialize() {
        try {
            this.populateQueryParams();
            this.populateHeaders();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public HttpResponse execute() throws Exception {
        byte[] requestBody = null;
        if (this.request.getEntity() != null) {
            if (InputStream.class.isAssignableFrom(this.request.getEntity().getClass())) {
                requestBody = ByteStreams.toByteArray((InputStream)((InputStream)this.request.getEntity()));
            } else {
                String content = ObjectMapperSingleton.getContext(this.request.getEntity().getClass()).writer().writeValueAsString(this.request.getEntity());
                requestBody = content.getBytes();
            }
        } else if (this.request.hasJson()) {
            requestBody = this.request.getJson().getBytes();
        }
        try {
            this.connection.setRequestMethod(this.request.getMethod().name());
            if (requestBody != null) {
                this.connection.setDoOutput(true);
                BufferedOutputStream out = new BufferedOutputStream(this.connection.getOutputStream());
                out.write(requestBody);
                out.flush();
            }
            byte[] data = null;
            int status = this.connection.getResponseCode();
            if (status >= 200 && status < 300) {
                data = ByteStreams.toByteArray((InputStream)this.connection.getInputStream());
            }
            HttpResponseImpl httpResponseImpl = HttpResponseImpl.wrap(this.connection.getHeaderFields(), status, this.connection.getResponseMessage(), data);
            return httpResponseImpl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            this.connection.disconnect();
        }
    }

    public boolean hasEntity() {
        return this.request.getEntity() != null;
    }

    public int getRetries() {
        return this.retries;
    }

    public HttpCommand<R> incrementRetriesAndReturn() {
        this.initialize();
        ++this.retries;
        return this;
    }

    public HttpRequest<R> getRequest() {
        return this.request;
    }

    private void populateQueryParams() throws MalformedURLException {
        StringBuilder url = new StringBuilder();
        url.append(new EndpointURIFromRequestFunction().apply(this.request));
        if (!this.request.hasQueryParams()) {
            this.connectionUrl = new URL(url.toString());
            return;
        }
        url.append("?");
        for (Map.Entry entry : this.request.getQueryParams().entrySet()) {
            for (Object o : (List)entry.getValue()) {
                try {
                    url.append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(String.valueOf(o), "UTF-8"));
                    url.append("&");
                }
                catch (UnsupportedEncodingException e) {
                    LOG.error(e.getMessage(), new Object[]{e});
                }
            }
        }
        if (url.charAt(url.length() - 1) == '&') {
            url.deleteCharAt(url.length() - 1);
        }
        this.connectionUrl = new URL(url.toString());
    }

    private void populateHeaders() throws IOException {
        if (this.request.getConfig() != null && this.request.getConfig().getProxy() != null) {
            Config config = this.request.getConfig();
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.getProxy().getRawHost(), config.getProxy().getPort()));
            this.connection = (HttpURLConnection)this.connectionUrl.openConnection(proxy);
        } else {
            this.connection = (HttpURLConnection)this.connectionUrl.openConnection();
        }
        this.connection.setRequestProperty("Content-Type", this.request.getContentType());
        this.connection.setRequestProperty("Accept", MediaType.JSON_UTF_8.toString());
        if (!this.request.hasHeaders()) {
            return;
        }
        for (Map.Entry h : this.request.getHeaders().entrySet()) {
            this.connection.setRequestProperty((String)h.getKey(), String.valueOf(h.getValue()));
        }
    }
}

