/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.openstack.logging.Logger;
import org.openstack4j.openstack.logging.LoggerFactory;

public class HttpResponseImpl
implements HttpResponse {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseImpl.class);
    private Map<String, List<String>> headers;
    private int responseCode;
    private String responseMessage;
    private byte[] data;

    private HttpResponseImpl(Map<String, List<String>> headers, int responseCode, String responseMessage, byte[] data) {
        this.headers = headers;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.data = data;
    }

    public static HttpResponseImpl wrap(Map<String, List<String>> headers, int responseCode, String responseMessage, byte[] data) {
        return new HttpResponseImpl(headers, responseCode, responseMessage, data);
    }

    public <T> T getEntity(Class<T> returnType) {
        return this.getEntity(returnType, null);
    }

    public <T> T getEntity(Class<T> returnType, ExecutionOptions<T> options) {
        return (T)HttpEntityHandler.handle((HttpResponse)this, returnType, options, (boolean)Boolean.TRUE);
    }

    public int getStatus() {
        return this.responseCode;
    }

    public String getStatusMessage() {
        return this.responseMessage;
    }

    public InputStream getInputStream() {
        if (this.data == null) {
            return null;
        }
        return new ByteArrayInputStream(this.data);
    }

    public String header(String name) {
        if (name == null) {
            return null;
        }
        for (String key : this.headers.keySet()) {
            if (key == null || !key.equalsIgnoreCase(name)) continue;
            return this.headers.get(key).get(0);
        }
        return null;
    }

    public Map<String, String> headers() {
        HashMap<String, String> retHeaders = new HashMap<String, String>();
        Set<String> keys = this.headers.keySet();
        for (String key : keys) {
            List<String> values = this.headers.get(key);
            for (String value : values) {
                retHeaders.put(key, value);
            }
        }
        return retHeaders;
    }

    public <T> T readEntity(Class<T> typeToReadAs) {
        if (this.data == null) {
            return null;
        }
        try {
            return (T)ObjectMapperSingleton.getContext(typeToReadAs).reader(typeToReadAs).readValue(this.data);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, e.getMessage(), new Object[0]);
            throw new ClientResponseException(e.getMessage(), 0, (Throwable)e);
        }
    }

    public void close() throws IOException {
    }

    public String getContentType() {
        return this.header("Content-Type");
    }
}

