/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.openstack4j.api.exceptions.ClientResponseException;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.openstack.logging.Logger;
import org.openstack4j.openstack.logging.LoggerFactory;

public class HttpResponseImpl
implements HttpResponse {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseImpl.class);
    private CloseableHttpResponse response;

    private HttpResponseImpl(CloseableHttpResponse response) {
        this.response = response;
    }

    public static HttpResponseImpl wrap(CloseableHttpResponse response) {
        return new HttpResponseImpl(response);
    }

    public CloseableHttpResponse unwrap() {
        return this.response;
    }

    public <T> T getEntity(Class<T> returnType) {
        return this.getEntity(returnType, null);
    }

    public <T> T getEntity(Class<T> returnType, ExecutionOptions<T> options) {
        return (T)HttpEntityHandler.handle((HttpResponse)this, returnType, options, (boolean)Boolean.TRUE);
    }

    public int getStatus() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getStatusMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public InputStream getInputStream() {
        HttpEntity entity = this.response.getEntity();
        try {
            if (entity != null) {
                return entity.getContent();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), new Object[]{e});
        }
        return null;
    }

    public String header(String name) {
        Header header = this.response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    public Map<String, String> headers() {
        Header[] headers;
        HashMap<String, String> retHeaders = new HashMap<String, String>();
        for (Header h : headers = this.response.getAllHeaders()) {
            retHeaders.put(h.getName(), h.getValue());
        }
        return retHeaders;
    }

    public <T> T readEntity(Class<T> typeToReadAs) {
        HttpEntity entity = this.response.getEntity();
        try {
            return (T)ObjectMapperSingleton.getContext(typeToReadAs).reader(typeToReadAs).readValue(entity.getContent());
        }
        catch (Exception e) {
            LOG.error((Throwable)e, e.getMessage(), new Object[0]);
            throw new ClientResponseException(e.getMessage(), 0, (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.response != null) {
            this.response.close();
        }
    }
}

