/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.resteasy.executors;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.openstack4j.core.transport.Config;

public class ApacheHttpClientExecutor
extends ApacheHttpClient4Executor {
    ApacheHttpClientExecutor(HttpClient client) {
        super(client);
    }

    public static ApacheHttpClientExecutor create(Config config) {
        BasicHttpParams params = new BasicHttpParams();
        if (config.getReadTimeout() > 0) {
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)config.getReadTimeout());
        }
        if (config.getConnectTimeout() > 0) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)config.getConnectTimeout());
        }
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        if (config.getProxy() != null) {
            try {
                URL url = new URL(config.getProxy().getHost());
                HttpHost proxy = new HttpHost(url.getHost(), config.getProxy().getPort(), url.getProtocol());
                client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return new ApacheHttpClientExecutor((HttpClient)client);
    }
}

