/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.resteasy;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.ClientResponse;
import org.openstack4j.core.transport.ExecutionOptions;
import org.openstack4j.core.transport.HttpEntityHandler;
import org.openstack4j.core.transport.HttpResponse;

public class HttpResponseImpl
implements HttpResponse {
    private final ClientResponse<?> response;

    private HttpResponseImpl(ClientResponse<?> response) {
        this.response = response;
    }

    public static HttpResponseImpl wrap(ClientResponse<?> response) {
        return new HttpResponseImpl(response);
    }

    public ClientResponse<?> unwrap() {
        return this.response;
    }

    public <T> T getEntity(Class<T> returnType) {
        return this.getEntity(returnType, null);
    }

    public <T> T getEntity(Class<T> returnType, ExecutionOptions<T> options) {
        return (T)HttpEntityHandler.handle((HttpResponse)this, returnType, options, (boolean)Boolean.TRUE);
    }

    public int getStatus() {
        return this.response.getStatus();
    }

    public String getStatusMessage() {
        return this.response.getResponseStatus().getReasonPhrase();
    }

    public InputStream getInputStream() {
        return (InputStream)this.response.getEntity(InputStream.class);
    }

    public String header(String name) {
        return (String)this.response.getHeaders().getFirst((Object)name);
    }

    public Map<String, String> headers() {
        HashMap<String, String> headers = new HashMap<String, String>();
        MultivaluedMap responseHeaders = this.response.getHeaders();
        for (String key : responseHeaders.keySet()) {
            headers.put(key, ((String)responseHeaders.getFirst((Object)key)).toString());
        }
        return headers;
    }

    public <T> T readEntity(Class<T> typeToReadAs) {
        return (T)this.response.getEntity(typeToReadAs);
    }

    public void close() throws IOException {
        this.response.releaseConnection();
    }

    public String getContentType() {
        return this.header("Content-Type");
    }
}

