/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.plugins.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.openstack4j.openstack.logging.internal.BaseLogger;

public class Log4jLogger
extends BaseLogger {
    private final Logger logger;
    private final String category;

    Log4jLogger(String category, Logger logger) {
        this.category = category;
        this.logger = logger;
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public String getCategory() {
        return this.category;
    }

    protected void logError(String message, Throwable e) {
        this.logger.error((Object)message, e);
    }

    protected void logError(String message) {
        this.logger.error((Object)message);
    }

    protected void logWarn(String message, Throwable e) {
        this.logger.warn((Object)message, e);
    }

    protected void logWarn(String message) {
        this.logger.warn((Object)message);
    }

    protected void logInfo(String message) {
        this.logger.info((Object)message);
    }

    protected void logDebug(String message) {
        this.logger.debug((Object)message);
    }

    protected void logTrace(String message) {
        this.logger.trace((Object)message);
    }
}

