/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.tools.runner;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class PantsRunner {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Usage: java -cp synthetic_jar org.pantsbuild.tools.runner.PantsRunner main_class args.\nSynthetic jar should contain manifest file with properly declared Class-Path property.");
            System.exit(1);
        }
        List<File> list = PantsRunner.readClasspath();
        PantsRunner.updateClassPathProperty(list);
        PantsRunner.updateClassLoader(PantsRunner.getClassLoader(), list);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        PantsRunner.runMainMethod(stringArray[0], stringArray2);
    }

    private static List<File> readClasspath() throws IOException, URISyntaxException {
        URL[] uRLArray = PantsRunner.getClassLoader().getURLs();
        if (uRLArray.length != 1 || !uRLArray[0].getProtocol().equals("file") || !uRLArray[0].toString().endsWith(".jar")) {
            throw new IllegalArgumentException("Should be exactly one jar file in the classpath.");
        }
        File file = new File(uRLArray[0].toURI());
        JarFile jarFile = new JarFile(file);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            throw new IllegalArgumentException("Supplied jar file doesn't contains manifest file.");
        }
        String string = manifest.getMainAttributes().getValue("Class-Path");
        if (string == null) {
            throw new IllegalArgumentException("Supplied jar file's manifest doesn't contains Class-Path section.");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string2 : string.split("\\s")) {
            arrayList.add(new File(file.getParent(), string2));
        }
        return arrayList;
    }

    private static URLClassLoader getClassLoader() {
        return (URLClassLoader)Thread.currentThread().getContextClassLoader();
    }

    private static void updateClassPathProperty(List<File> list) {
        System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + Joiner.on((char)':').join(list));
    }

    private static void updateClassLoader(URLClassLoader uRLClassLoader, List<File> list) throws ReflectiveOperationException, MalformedURLException {
        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        for (File file : list) {
            method.invoke((Object)uRLClassLoader, file.toURI().toURL());
        }
    }

    private static void runMainMethod(String string, String[] stringArray) throws ReflectiveOperationException {
        Method method = Class.forName(string, true, PantsRunner.getClassLoader()).getDeclaredMethod("main", String[].class);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method 'main' for " + string + " is not static.");
        }
        method.invoke(null, new Object[]{stringArray});
    }
}

