/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc.compiler;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.martiansoftware.nailgun.NGContext;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.pantsbuild.zinc.analysis.AnalysisMap;
import org.pantsbuild.zinc.analysis.AnalysisMap$;
import org.pantsbuild.zinc.compiler.BareBonesLogger;
import org.pantsbuild.zinc.compiler.InputUtils$;
import org.pantsbuild.zinc.compiler.Main;
import org.pantsbuild.zinc.compiler.OutputUtils$;
import org.pantsbuild.zinc.compiler.Settings;
import org.pantsbuild.zinc.compiler.Settings$;
import org.pantsbuild.zinc.util.Util$;
import sbt.internal.inc.ConcreteAnalysisContents;
import sbt.internal.inc.IncrementalCompilerImpl;
import sbt.internal.util.BasicLogger;
import sbt.internal.util.ConsoleLogger;
import sbt.internal.util.ConsoleLogger$;
import sbt.internal.util.ConsoleOut$;
import sbt.io.IO$;
import sbt.util.Level$;
import sbt.util.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;
import xsbti.CompileFailed;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileResult;
import xsbti.compile.Inputs;
import xsbti.compile.PreviousResult;

public final class Main$ {
    public static Main$ MODULE$;
    private Main.Version zincVersion;
    private String versionString;
    private volatile byte bitmap$0;

    static {
        new Main$();
    }

    private Main.Version zincVersion$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Properties props = Util$.MODULE$.propertiesFromResource("zinc.version.properties", this.getClass().getClassLoader());
                this.zincVersion = new Main.Version(props.getProperty("version", "unknown"), props.getProperty("timestamp", ""), props.getProperty("commit", ""));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.zincVersion;
    }

    public Main.Version zincVersion() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.zincVersion$lzycompute() : this.zincVersion;
    }

    private String versionString$lzycompute() {
        Main$ main$ = this;
        synchronized (main$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.versionString = this.zincVersion().published().endsWith("-SNAPSHOT") ? new StringOps(Predef$.MODULE$.augmentString("%s %s-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zincVersion().published(), this.zincVersion().timestamp(), new StringOps(Predef$.MODULE$.augmentString(this.zincVersion().commit())).take(10)})) : this.zincVersion().published();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.versionString;
    }

    public String versionString() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.versionString$lzycompute() : this.versionString;
    }

    public BasicLogger mkLogger(Settings settings) {
        if (!Util$.MODULE$.isSetProperty("log4j2.disable.jmx")) {
            Util$.MODULE$.setProperty("log4j2.disable.jmx", "true");
        }
        System.setProperty("sbt.log.format", "true");
        return settings.consoleLog().useBarebonesLogger() ? new BareBonesLogger(settings.consoleLog().logLevel()) : Main$.mkConsoleLogger$1(settings.consoleLog().logLevel(), settings.consoleLog().color());
    }

    public String[] preprocessArgs(String[] rawArgs, Option<File> nailMainCWD) {
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rawArgs)).partition((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("@")));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] argFiles = (String[])tuple2._1();
        String[] partialArgs = (String[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)argFiles, (Object)partialArgs);
        Tuple2 tuple23 = tuple22;
        String[] argFiles2 = (String[])tuple23._1();
        String[] partialArgs2 = (String[])tuple23._2();
        String[] args = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partialArgs2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])argFiles2)).flatMap((Function1 & Serializable & scala.Serializable)f -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readLines((File)Util$.MODULE$.normalizeIfExists(nailMainCWD, new File((String)new StringOps(Predef$.MODULE$.augmentString(f)).drop(1))), (Charset)Charsets.UTF_8)).asScala(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] fixedArgs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).flatMap((Function1 & Serializable & scala.Serializable)arg -> {
            Seq seq;
            String string = arg;
            if (string.startsWith("-C") || string.startsWith("-S")) {
                Tuple2 tup = new StringOps(Predef$.MODULE$.augmentString(arg)).splitAt(2);
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)tup._1(), (String)tup._2()}));
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string}));
            }
            return seq;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fixedArgs)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block7: {
                block6: {
                    block5: {
                        block4: {
                            String string = fixedArgs[i - 1];
                            String string2 = "-classpath";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                fixedArgs$1[i - 1] = "--classpath";
                            }
                            String string3 = fixedArgs[i - 1];
                            String string4 = "--classpath";
                            if (!(string3 == null ? string4 != null : !string3.equals(string4))) break block4;
                            String string5 = fixedArgs[i - 1];
                            String string6 = "-cp";
                            if (!(string5 == null ? string6 != null : !string5.equals(string6))) break block4;
                            String string7 = fixedArgs[i - 1];
                            String string8 = "--scala-path";
                            if (!(string7 == null ? string8 != null : !string7.equals(string8))) break block4;
                            String string9 = fixedArgs[i - 1];
                            String string10 = "-scala-path";
                            if (string9 != null ? !string9.equals(string10) : string10 != null) break block5;
                        }
                        fixedArgs$1[i] = fixedArgs[i].replace(":", ",");
                    }
                    String string = fixedArgs[i - 1];
                    String string11 = "--analysis-map";
                    if (!(string == null ? string11 != null : !string.equals(string11))) break block6;
                    String string12 = fixedArgs[i - 1];
                    String string13 = "-analysis-map";
                    if (string12 != null ? !string12.equals(string13) : string13 != null) break block7;
                }
                fixedArgs$1[i] = fixedArgs[i].replace(":", "=");
            }
        });
        return fixedArgs;
    }

    public void main(String[] args) {
        Settings settings;
        long startTime = System.currentTimeMillis();
        Option option = Settings$.MODULE$.SettingsParser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.preprocessArgs(args, (Option<File>)None$.MODULE$)), (Object)new Settings(Settings$.MODULE$.apply$default$1(), Settings$.MODULE$.apply$default$2(), Settings$.MODULE$.apply$default$3(), Settings$.MODULE$.apply$default$4(), Settings$.MODULE$.apply$default$5(), Settings$.MODULE$.apply$default$6(), Settings$.MODULE$.apply$default$7(), Settings$.MODULE$.apply$default$8(), Settings$.MODULE$.apply$default$9(), Settings$.MODULE$.apply$default$10(), Settings$.MODULE$.apply$default$11(), Settings$.MODULE$.apply$default$12(), Settings$.MODULE$.apply$default$13(), Settings$.MODULE$.apply$default$14(), Settings$.MODULE$.apply$default$15()));
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                Predef$.MODULE$.println((Object)"See zinc-compiler --help for information about options");
                throw package$.MODULE$.exit(1);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Settings settings2 = settings = (Settings)some.value();
        Settings settings3 = settings2;
        this.mainImpl(settings3.withAbsolutePaths(Paths.get(".", new String[0]).toAbsolutePath().toFile()), startTime, (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)n -> package$.MODULE$.exit(1));
    }

    public void nailMain(NGContext context) {
        long startTime = System.currentTimeMillis();
        Option option = Settings$.MODULE$.SettingsParser().parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.preprocessArgs(context.getArgs(), (Option<File>)new Some((Object)new File(context.getWorkingDirectory())))), (Object)new Settings(Settings$.MODULE$.apply$default$1(), Settings$.MODULE$.apply$default$2(), Settings$.MODULE$.apply$default$3(), Settings$.MODULE$.apply$default$4(), Settings$.MODULE$.apply$default$5(), Settings$.MODULE$.apply$default$6(), Settings$.MODULE$.apply$default$7(), Settings$.MODULE$.apply$default$8(), Settings$.MODULE$.apply$default$9(), Settings$.MODULE$.apply$default$10(), Settings$.MODULE$.apply$default$11(), Settings$.MODULE$.apply$default$12(), Settings$.MODULE$.apply$default$13(), Settings$.MODULE$.apply$default$14(), Settings$.MODULE$.apply$default$15()));
        if (option instanceof Some) {
            Some some = (Some)option;
            Settings settings = (Settings)some.value();
            Settings settingsWithAbsPath = settings.withAbsolutePaths(new File(context.getWorkingDirectory()));
            this.mainImpl(settingsWithAbsPath, startTime, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)n -> context.exit(n));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)"See zinc-compiler --help for information about options");
            context.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void mainImpl(Settings settings, long startTime, Function1<Object, BoxedUnit> exit) {
        AnalysisMap analysisMap;
        Tuple2<AnalysisStore, PreviousResult> tuple2;
        BasicLogger log = this.mkLogger(settings);
        boolean isDebug = settings.consoleLog().logLevel().$less$eq((Object)Level$.MODULE$.Debug());
        if (settings.sources().isEmpty()) {
            exit.apply$mcVI$sp(1);
        }
        if ((tuple2 = InputUtils$.MODULE$.loadDestinationAnalysis(settings, analysisMap = AnalysisMap$.MODULE$.create(settings.analysis()), (Logger)log)) == null) {
            throw new MatchError(tuple2);
        }
        AnalysisStore targetAnalysisStore = (AnalysisStore)tuple2._1();
        PreviousResult previousResult = (PreviousResult)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)targetAnalysisStore, (Object)previousResult);
        Tuple2 tuple23 = tuple22;
        AnalysisStore targetAnalysisStore2 = (AnalysisStore)tuple23._1();
        PreviousResult previousResult2 = (PreviousResult)tuple23._2();
        Inputs inputs = InputUtils$.MODULE$.create(settings, analysisMap, previousResult2, (Logger)log);
        if (isDebug) {
            log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Inputs: ").append(inputs).toString());
        }
        try {
            CompileResult result = new IncrementalCompilerImpl().compile(inputs, (xsbti.Logger)log);
            if (settings.postCompileMergeDir().isDefined()) {
                IO$.MODULE$.copyDirectory(new File(((File)settings.postCompileMergeDir().get()).toURI()), new File(settings.classesDirectory().toURI()));
            }
            if (result.hasModified()) {
                targetAnalysisStore2.set((AnalysisContents)new ConcreteAnalysisContents(result.analysis(), result.setup()));
            }
            log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Compile success ").append(Util$.MODULE$.timing(startTime)).toString());
            if (settings.outputJar().isDefined()) {
                Path outputJarPath = ((File)settings.outputJar().get()).toPath();
                File classesDirectory = settings.classesDirectory();
                log.debug((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Creating JAR at %s, for files at %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputJarPath, classesDirectory})));
                OutputUtils$.MODULE$.createClassesJar(classesDirectory, outputJarPath, settings.creationTime());
            }
        }
        catch (CompileFailed e) {
            log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Compile failed ").append(Util$.MODULE$.timing(startTime)).toString());
            exit.apply$mcVI$sp(1);
        }
        catch (Exception e) {
            String message;
            if (isDebug) {
                e.printStackTrace();
            }
            if ((message = e.getMessage()) != null) {
                log.error((Function0 & Serializable & scala.Serializable)() -> message);
            }
            exit.apply$mcVI$sp(1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final ConsoleLogger mkConsoleLogger$1(Enumeration.Value level, boolean color) {
        void var2_2;
        ConsoleLogger cl = ConsoleLogger$.MODULE$.apply(ConsoleOut$.MODULE$.systemOut(), color, ConsoleLogger$.MODULE$.apply$default$3(), ConsoleLogger$.MODULE$.apply$default$4());
        cl.setLevel(level);
        return var2_2;
    }

    private Main$() {
        MODULE$ = this;
    }
}

