/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.zinc.compiler;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.TreeSet;
import scala.collection.mutable.TreeSet$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class OutputUtils$ {
    public static OutputUtils$ MODULE$;

    static {
        new OutputUtils$();
    }

    /*
     * WARNING - void declaration
     */
    public TreeSet<Path> sort(File dir) {
        void var2_2;
        TreeSet sorted = new TreeSet(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        SimpleFileVisitor<Path> fileSortVisitor = new SimpleFileVisitor<Path>(sorted){
            private final TreeSet sorted$1;

            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
                this.sorted$1.add((Object)path);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                this.sorted$1.add((Object)path);
                return FileVisitResult.CONTINUE;
            }
            {
                this.sorted$1 = sorted$1;
            }
        };
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)fileSortVisitor);
        return var2_2;
    }

    public String relativize(String base, Path path) {
        return new File(base.toString()).toURI().relativize(new File(((Object)path).toString()).toURI()).getPath();
    }

    public void createJar(String base, TreeSet<Path> paths, Path outputJarPath, long jarEntryTime) {
        JarOutputStream target = new JarOutputStream(Files.newOutputStream(outputJarPath, new OpenOption[0]));
        ((TraversableLike)paths.map((Function1 & Serializable & scala.Serializable)path -> {
            String relativePath = MODULE$.relativize(base, (Path)path);
            return new Tuple2(path, (Object)relativePath);
        }, TreeSet$.MODULE$.canBuildFrom(Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), (Ordering)Ordering.String$.MODULE$)))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OutputUtils$.$anonfun$createJar$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            OutputUtils$.$anonfun$createJar$3(target, jarEntryTime, x$2);
            return BoxedUnit.UNIT;
        });
        target.close();
    }

    public void createClassesJar(File classesDirectory, Path outputJarPath, long jarCreationTime) {
        TreeSet<Path> sortedClasses = this.sort(classesDirectory);
        this.createJar(classesDirectory.toString(), sortedClasses, outputJarPath, jarCreationTime);
    }

    public boolean existsClass(Path jarPath, String fileName) {
        ObjectRef jis = ObjectRef.create(null);
        boolean found = false;
        try {
            jis.elem = new JarInputStream(Files.newInputStream(jarPath, new OpenOption[0]));
            found = this.findClass$1(((JarInputStream)jis.elem).getNextJarEntry(), fileName, jis);
        }
        finally {
            ((JarInputStream)jis.elem).close();
        }
        return found;
    }

    /*
     * WARNING - void declaration
     */
    private static final JarEntry jarEntry$1(String name, long jarEntryTime$1) {
        void var3_2;
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(jarEntryTime$1);
        return var3_2;
    }

    private static final void addToJar$1(Path source, String entryName, JarOutputStream target$1, long jarEntryTime$1) {
        Long l;
        if (source.toFile().isDirectory()) {
            target$1.putNextEntry(OutputUtils$.jarEntry$1(entryName.endsWith("/") ? entryName : new StringBuilder(0).append(entryName).append('/').toString(), jarEntryTime$1));
            l = BoxedUnit.UNIT;
        } else {
            target$1.putNextEntry(OutputUtils$.jarEntry$1(entryName, jarEntryTime$1));
            l = BoxesRunTime.boxToLong((long)Files.copy(source, target$1));
        }
        target$1.closeEntry();
    }

    public static final /* synthetic */ boolean $anonfun$createJar$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String relativePath = (String)tuple2._2();
        boolean bl = new StringOps(Predef$.MODULE$.augmentString(relativePath)).nonEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createJar$3(JarOutputStream target$1, long jarEntryTime$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Path path = (Path)tuple2._1();
        String relativePath = (String)tuple2._2();
        OutputUtils$.addToJar$1(path, relativePath, target$1, jarEntryTime$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean findClass$1(JarEntry entry, String fileName$1, ObjectRef jis$1) {
        boolean bl;
        while (true) {
            JarEntry jarEntry;
            if ((jarEntry = entry) == null) {
                bl = false;
                break;
            }
            String string = jarEntry.getName();
            String string2 = fileName$1;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                bl = true;
                break;
            }
            entry = ((JarInputStream)jis$1.elem).getNextJarEntry();
        }
        return bl;
    }

    private OutputUtils$() {
        MODULE$ = this;
    }
}

