/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.errors;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ProceduresOnError {
    Map<Object, Exception> mapProceduresInError = new ConcurrentHashMap<Object, Exception>();
    Map<Object, Exception> mapProceduresHandledInError = new ConcurrentHashMap<Object, Exception>();

    public void addProcedureInError(Object procedure, Exception exception) {
        this.mapProceduresInError.put(procedure, exception);
    }

    public void addProcedureHandledInError(Object procedure, Exception exception) {
        this.mapProceduresHandledInError.put(procedure, exception);
    }

    public boolean isExceptionForProcedure(Object procedure) {
        return this.mapProceduresInError.get(procedure) != null;
    }

    public boolean isExceptionHandledForProcedure(Object procedure) {
        return this.mapProceduresHandledInError.get(procedure) != null;
    }

    public boolean isErrorOfType(Class<?> error) {
        for (Map.Entry<Object, Exception> entry : this.mapProceduresInError.entrySet()) {
            if (!entry.getValue().getClass().equals(error)) continue;
            return true;
        }
        return false;
    }

    public boolean isHandledErrorOfType(Class<?> error) {
        for (Map.Entry<Object, Exception> entry : this.mapProceduresHandledInError.entrySet()) {
            if (!entry.getValue().getClass().equals(error)) continue;
            return true;
        }
        return false;
    }

    public boolean isErrorForProcedureOfType(Class<?> proc) {
        for (Object entry : this.mapProceduresInError.keySet()) {
            if (!entry.getClass().equals(proc)) continue;
            return true;
        }
        return false;
    }

    public boolean isHandledErrorForProcedureOfType(Class<?> proc) {
        for (Object entry : this.mapProceduresHandledInError.keySet()) {
            if (!entry.getClass().equals(proc)) continue;
            return true;
        }
        return false;
    }

    public Exception getExceptionForProcedure(Object procedure) {
        try {
            return this.mapProceduresInError.get(procedure);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Exception getHandledExceptionForProcedure(Object procedure) {
        try {
            return this.mapProceduresHandledInError.get(procedure);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Exception getAndRemoveExceptionForProcedure(Object procedure) {
        try {
            return this.mapProceduresInError.remove(procedure);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Exception getAndRemoveHandledExceptionForProcedure(Object procedure) {
        try {
            return this.mapProceduresHandledInError.remove(procedure);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getNumberOfProceduresInError() {
        return this.mapProceduresInError.size();
    }

    public long getNumberOfHandledProceduresInError() {
        return this.mapProceduresHandledInError.size();
    }

    public Set<Object> getProceduresInError() {
        return this.mapProceduresInError.keySet();
    }

    public Set<Object> getProceduresHandledInError() {
        return this.mapProceduresHandledInError.keySet();
    }

    public String toString() {
        String format = "[%s [%s]] ";
        StringBuffer strb = new StringBuffer();
        for (Object procedure : this.mapProceduresInError.keySet()) {
            strb.append(String.format(format, procedure, this.mapProceduresInError.get(procedure)));
        }
        return strb.toString();
    }
}

