/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.inout;

import java.lang.reflect.Method;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.inout.InOut;
import org.parallelj.launching.parser.Parser;

public class Argument
extends InOut {
    private Method writeMethod;
    private Class<? extends Parser> parser;
    private Parser parserInstance;

    public Argument(String name, int number, Class<?> type, Class<? extends Parser> parserClass, Method writeMethod) {
        this(name, number, type, parserClass, writeMethod, null);
    }

    public Argument(String name, int number, Class<?> type, Class<? extends Parser> parserClass, Method writeMethod, Object value) {
        this.name = name;
        this.index = number;
        this.type = type;
        this.parser = parserClass;
        this.value = value;
        this.writeMethod = writeMethod;
        this.instanciateParser();
    }

    public final String toString() {
        return "Argument=>name[" + this.name + "]_type[" + this.type + "]_parser:[" + this.parser + "]_value:[" + this.value + "]";
    }

    public final Class<? extends Parser> getParser() {
        return this.parser;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public void setValueUsingParser(String value) {
        if (this.parserInstance == null) {
            this.instanciateParser();
        }
        this.value = this.parserInstance.parse(value);
    }

    private void instanciateParser() {
        if (this.parser != null) {
            try {
                this.parserInstance = this.parser.newInstance();
            }
            catch (InstantiationException e) {
                LaunchingMessageKind.EREMOTE0007.format(this.parser.getCanonicalName(), e);
            }
            catch (IllegalAccessException e) {
                LaunchingMessageKind.EREMOTE0007.format(this.parser.getCanonicalName(), e);
            }
        }
    }
}

