/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.internal;

import org.parallelj.internal.reflect.ProcessHelperImpl;
import org.parallelj.launching.errors.ProceduresOnError;
import org.parallelj.launching.errors.ProceduresOnErrorManagement;
import org.parallelj.launching.quartz.Launch;
import org.parallelj.launching.quartz.LaunchException;
import org.parallelj.launching.quartz.Launcher;
import org.quartz.JobDataMap;

public class DefaultLauncher {
    Class<?> program;

    public static void main(String[] args) {
        String className = args[0];
        Class<?> programClass = null;
        Object programInstance = null;
        try {
            programClass = Class.forName(className);
            programInstance = programClass.newInstance();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        ArgEntry[] arguments = new ArgEntry[args.length - 1];
        try {
            int cpt = 1;
            while (cpt < args.length) {
                arguments[cpt - 1] = new ArgEntry(args[cpt]);
                ++cpt;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        if (programInstance != null) {
            Launcher launcher = null;
            Launch launch = null;
            try {
                try {
                    launcher = Launcher.getLauncher();
                    launch = launcher.newLaunch(programClass);
                    ArgEntry[] argEntryArray = arguments;
                    int n = arguments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ArgEntry entry = argEntryArray[n2];
                        launch.addParameter(entry.argumentName, entry.stringValue);
                        ++n2;
                    }
                    launch.synchLaunch();
                    JobDataMap jobDataMap = launch.getLaunchResult();
                    System.out.println("Program status [" + jobDataMap.get((Object)"RETURN_CODE") + "] Return code [" + jobDataMap.get((Object)"USER_RETURN_CODE") + "]");
                    ProcessHelperImpl processhelper = (ProcessHelperImpl)jobDataMap.get((Object)"CONTEXT");
                    ProceduresOnError procOnError = ProceduresOnErrorManagement.getProceduresInErrors(processhelper.getProcess());
                    if (procOnError != null && procOnError.getNumberOfProceduresInError() > 0L) {
                        System.err.println("Program terminated with errors: " + procOnError);
                    }
                }
                catch (LaunchException e) {
                    e.printStackTrace();
                    if (launcher != null) {
                        launcher.complete();
                    }
                }
            }
            finally {
                if (launcher != null) {
                    launcher.complete();
                }
            }
        }
    }

    private static class ArgEntry {
        public String argumentName;
        public String stringValue;

        public ArgEntry(String arg) {
            int valIndex = arg.indexOf(61);
            this.argumentName = arg.substring(0, valIndex);
            this.stringValue = arg.substring(valIndex + 1);
        }
    }
}

