/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.parallelj.Programs;
import org.parallelj.internal.reflect.ProgramAdapter;
import org.parallelj.launching.internal.LaunchingListener;
import org.quartz.JobExecutionContext;

public class LaunchingObservable {
    private static final ServiceLoader<LaunchingListener> loader = ServiceLoader.load(LaunchingListener.class);
    private static final List<Class<? extends LaunchingListener>> listenersClasses = new ArrayList<Class<? extends LaunchingListener>>();
    private List<LaunchingListener> listeners = new ArrayList<LaunchingListener>();

    static {
        ArrayList<LaunchingListener> lst = new ArrayList<LaunchingListener>();
        for (LaunchingListener listener : loader) {
            lst.add(listener);
        }
        Collections.sort(lst, new LaunchingListenerComparator());
        for (LaunchingListener launchingListener : lst) {
            listenersClasses.add(launchingListener.getClass());
        }
    }

    public LaunchingObservable() {
        for (Class<? extends LaunchingListener> listenerClass : listenersClasses) {
            try {
                this.listeners.add(listenerClass.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void prepareLaunching(ProgramAdapter.Adapter adapter, Programs.ProcessHelper<?> processHelper, JobExecutionContext context) {
        for (LaunchingListener listener : this.listeners) {
            try {
                listener.prepareLaunching(adapter, processHelper, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void finalizeLaunching(ProgramAdapter.Adapter adapter, Programs.ProcessHelper<?> processHelper, JobExecutionContext context) {
        for (LaunchingListener listener : this.listeners) {
            try {
                listener.finalizeLaunching(adapter, processHelper, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class LaunchingListenerComparator
    implements Comparator<LaunchingListener> {
        private LaunchingListenerComparator() {
        }

        @Override
        public int compare(LaunchingListener o1, LaunchingListener o2) {
            if (o1.getPriority() > o2.getPriority()) {
                return -1;
            }
            if (o1.getPriority() < o2.getPriority()) {
                return 1;
            }
            return 0;
        }
    }
}

