/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ParallelJThreadFactory
implements ThreadFactory {
    private static final String defaultThreadGroupName = "//J-";
    private static final String defaultThreadName = "//J-Thread-";
    private String threadName = "//J-Thread-";
    private AtomicLong counter = new AtomicLong();
    private ThreadGroup threadGroup;

    public ParallelJThreadFactory() {
        this.threadGroup = new ThreadGroup(defaultThreadGroupName);
        this.threadName = defaultThreadName;
    }

    public ParallelJThreadFactory(String threadName) {
        this.threadGroup = new ThreadGroup(defaultThreadGroupName);
        this.threadName = threadName;
    }

    public ParallelJThreadFactory(String threadName, String groupName) {
        this.threadGroup = new ThreadGroup(groupName);
        this.threadName = threadName;
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.threadGroup, r, String.valueOf(this.threadName) + this.counter.incrementAndGet());
    }
}

