/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.internal.ext;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.internal.ext.Extension;
import org.parallelj.launching.internal.ext.ExtensionException;

public class ExtensionService {
    private static ExtensionService extService = new ExtensionService();
    private ArrayList<Extension> exts = new ArrayList();

    private ExtensionService() {
        this.initialize();
    }

    private synchronized void initialize() {
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class);
        for (Extension ext : loader) {
            try {
                ext.init();
                this.exts.add(ext);
            }
            catch (ExtensionException e) {
                LaunchingMessageKind.EEXT002.format(ext.getClass().getCanonicalName(), "", e);
            }
        }
    }

    public static synchronized ExtensionService getExtensionService() {
        return extService;
    }

    public List<Extension> getExtensions() {
        return this.exts;
    }

    public List<Extension> getExtentionsByType(String type) {
        ArrayList<Extension> lstExtensions = new ArrayList<Extension>();
        for (Extension ext : this.exts) {
            if (!ext.getType().equalsIgnoreCase(type)) continue;
            lstExtensions.add(ext);
        }
        return lstExtensions;
    }
}

