/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.quartz;

import java.util.concurrent.CountDownLatch;
import org.parallelj.launching.LaunchingMessageKind;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public class AdapterJobListener
implements JobListener,
SchedulerListener {
    private Scheduler scheduler;
    private CountDownLatch latcher = null;
    private JobDataMap result = null;
    private String jobClass;
    private Job adapter;
    private String jobId = "unknown";

    public AdapterJobListener(String jobClass, Scheduler scheduler) {
        this.jobClass = jobClass;
        this.scheduler = scheduler;
    }

    public final String getJobId() {
        return this.jobId;
    }

    public void setLatcher(CountDownLatch latcher) {
        this.latcher = latcher;
    }

    public final String getName() {
        return this.toString();
    }

    public JobDataMap getResult() {
        return this.result;
    }

    public Job getAdapter() {
        return this.adapter;
    }

    public final void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        if (context.getFireInstanceId() != null) {
            this.jobId = context.getFireInstanceId();
        }
        this.result = (JobDataMap)context.getResult();
        if (this.result != null) {
            LaunchingMessageKind.IQUARTZ0003.format(this.jobClass, this.jobId, String.valueOf(this.result.get((Object)"RETURN_CODE")), String.valueOf(this.result.get((Object)"USER_RETURN_CODE")));
        }
        try {
            this.scheduler.getListenerManager().removeJobListener(this.getName());
        }
        catch (SchedulerException e) {
            LaunchingMessageKind.EQUARTZ0005.format(new Object[]{e});
        }
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (context.getFireInstanceId() != null) {
            this.jobId = context.getFireInstanceId();
            this.adapter = context.getJobInstance();
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        if (context.getFireInstanceId() != null) {
            this.jobId = context.getFireInstanceId();
        }
        this.result = (JobDataMap)context.getResult();
        if (this.latcher != null) {
            this.latcher.countDown();
        }
    }

    public void jobDeleted(JobKey jobKey) {
        if (this.latcher != null) {
            this.latcher.countDown();
        }
        try {
            this.scheduler.getListenerManager().removeJobListener(this.getName());
        }
        catch (SchedulerException e) {
            LaunchingMessageKind.EQUARTZ0004.format(new Object[]{this.jobClass, e});
        }
    }

    public void triggerFinalized(Trigger trigger) {
        if (this.latcher != null) {
            this.latcher.countDown();
        }
    }

    public void jobScheduled(Trigger trigger) {
    }

    public void jobUnscheduled(TriggerKey triggerKey) {
    }

    public void triggerPaused(TriggerKey triggerKey) {
    }

    public void triggersPaused(String triggerGroup) {
    }

    public void triggerResumed(TriggerKey triggerKey) {
    }

    public void triggersResumed(String triggerGroup) {
    }

    public void jobAdded(JobDetail jobDetail) {
    }

    public void jobPaused(JobKey jobKey) {
    }

    public void jobsPaused(String jobGroup) {
    }

    public void jobResumed(JobKey jobKey) {
    }

    public void jobsResumed(String jobGroup) {
    }

    public void schedulerError(String msg, SchedulerException cause) {
        LaunchingMessageKind.EQUARTZ0005.format(new Object[]{cause});
    }

    public void schedulerInStandbyMode() {
    }

    public void schedulerStarted() {
    }

    public void schedulerShutdown() {
    }

    public void schedulerShuttingdown() {
    }

    public void schedulingDataCleared() {
    }
}

