/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.quartz;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.quartz.AdapterJobListener;
import org.parallelj.launching.quartz.LaunchException;
import org.parallelj.launching.quartz.LaunchResult;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.EverythingMatcher;

public class Launch {
    private static final String DEFAULT_GROUP_NAME = "DEFAULT";
    public static final String DEFAULT_EXECUTOR_KEY = "EXECUTOR";
    public static final String PARAMETERS = "parameters";
    public static final String OUTPUTS = "outputs";
    private Scheduler scheduler;
    private LaunchResult launchResult;
    private Class<? extends Job> jobClass;
    private JobBuilder jobBuilder;
    private JobDetail job;
    private Job adapter;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Executor executorService = null;
    private TriggerBuilder<Trigger> triggerBuilder = TriggerBuilder.newTrigger();
    private Trigger trigger;
    private static final long MSECONDS = 500L;

    public Launch(Scheduler scheduler, Class<?> jobClass) throws LaunchException {
        this(scheduler, jobClass, null);
    }

    public Launch(Scheduler scheduler, Class<?> jobClass, ExecutorService executorService) throws LaunchException {
        this.scheduler = scheduler;
        this.executorService = executorService;
        try {
            this.jobClass = jobClass;
        }
        catch (ClassCastException e) {
            LaunchingMessageKind.ELAUNCH0001.format(jobClass, e);
            throw new LaunchException(e);
        }
        this.jobBuilder = JobBuilder.newJob(this.jobClass);
        this.job = this.jobBuilder.withIdentity(this.jobClass.getCanonicalName(), DEFAULT_GROUP_NAME).build();
        if (this.executorService != null) {
            this.job.getJobDataMap().put(DEFAULT_EXECUTOR_KEY, (Object)executorService);
        }
        this.trigger = this.triggerBuilder.withIdentity(String.valueOf(this.triggerBuilder), String.valueOf(this.triggerBuilder)).startNow().build();
    }

    public Launch synchLaunch() throws LaunchException {
        try {
            this.job.getJobDataMap().put(PARAMETERS, this.parameters);
            AdapterJobListener listener = new AdapterJobListener(this.jobClass.getCanonicalName(), this.scheduler);
            this.scheduler.getListenerManager().addJobListener((JobListener)listener, (Matcher)EverythingMatcher.allJobs());
            this.scheduler.getListenerManager().addSchedulerListener((SchedulerListener)listener);
            CountDownLatch latcher = this.createLatcher(listener);
            try {
                this.scheduler.scheduleJob(this.job, this.trigger);
            }
            catch (Exception e) {
                LaunchingMessageKind.EREMOTE0009.format(e);
            }
            this.scheduler.start();
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                LaunchingMessageKind.EREMOTE0009.format(e);
            }
            LaunchingMessageKind.IQUARTZ0002.format(this.jobClass.getCanonicalName(), listener.getJobId());
            this.awaitingLatcher(latcher, listener);
            this.adapter = listener.getAdapter();
            this.launchResult = new LaunchResult(listener.getJobId(), listener.getResult());
            this.launchResult.getResult().putAll((Map)this.job.getJobDataMap());
        }
        catch (SchedulerException e) {
            throw new LaunchException(e);
        }
        return this;
    }

    public Launch aSynchLaunch() throws LaunchException {
        try {
            this.job.getJobDataMap().put(PARAMETERS, this.parameters);
            AdapterJobListener listener = new AdapterJobListener(this.jobClass.getCanonicalName(), this.scheduler);
            this.scheduler.getListenerManager().addJobListener((JobListener)listener, (Matcher)EverythingMatcher.allJobs());
            this.scheduler.getListenerManager().addSchedulerListener((SchedulerListener)listener);
            this.scheduler.scheduleJob(this.job, this.trigger);
            this.scheduler.start();
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                LaunchingMessageKind.EREMOTE0009.format(e);
            }
            this.adapter = listener.getAdapter();
            LaunchingMessageKind.IQUARTZ0002.format(this.jobClass.getCanonicalName(), listener.getJobId());
            this.launchResult = new LaunchResult(listener.getJobId(), listener.getResult());
            this.launchResult.getResult().putAll((Map)this.job.getJobDataMap());
        }
        catch (SchedulerException e) {
            throw new LaunchException(e);
        }
        return this;
    }

    private CountDownLatch createLatcher(AdapterJobListener listener) {
        CountDownLatch latcher = new CountDownLatch(1);
        listener.setLatcher(latcher);
        return latcher;
    }

    private void awaitingLatcher(CountDownLatch latcher, AdapterJobListener listener) {
        if (latcher.getCount() > 0L) {
            try {
                latcher.await();
            }
            catch (InterruptedException e) {
                LaunchingMessageKind.EREMOTE0009.format(e);
            }
        }
        listener.setLatcher(null);
    }

    public synchronized Launch addDatas(JobDataMap jobDataMap) {
        this.job.getJobDataMap().putAll((Map)jobDataMap);
        return this;
    }

    public String getLaunchId() {
        return this.launchResult.getJobId();
    }

    public JobDataMap getLaunchResult() {
        return this.launchResult.getResult();
    }

    public Job getAdapter() {
        return this.adapter;
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public Map<String, Object> getOuputs() {
        return (Map)this.launchResult.getResult().get((Object)OUTPUTS);
    }
}

