/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.quartz;

import java.util.concurrent.ExecutorService;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.quartz.Launch;
import org.parallelj.launching.quartz.LaunchException;
import org.parallelj.launching.quartz.ParalleljScheduler;
import org.parallelj.launching.quartz.ParalleljSchedulerFactory;
import org.quartz.SchedulerException;

public final class Launcher {
    private ParalleljScheduler scheduler;
    private static Launcher instance;
    private static final long FIVE_SECONDS = 5000L;

    public static synchronized Launcher getLauncher() throws LaunchException {
        if (instance == null) {
            instance = new Launcher();
        }
        return instance;
    }

    private Launcher() throws LaunchException {
        try {
            this.scheduler = new ParalleljSchedulerFactory().getScheduler();
            this.scheduler.start();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                LaunchingMessageKind.EREMOTE0009.format(e);
            }
        }
        catch (SchedulerException e) {
            throw new LaunchException(e);
        }
    }

    public synchronized Launch newLaunch(Class<?> jobClass) throws LaunchException {
        return new Launch(this.scheduler, jobClass);
    }

    public synchronized Launch newLaunch(Class<?> jobClass, ExecutorService executorService) throws LaunchException {
        return new Launch(this.scheduler, jobClass, executorService);
    }

    public void complete() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            LaunchingMessageKind.EQUARTZ0005.format(new Object[]{e});
        }
    }
}

