/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.quartz;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.parallelj.internal.conf.ConfigurationManager;
import org.parallelj.internal.conf.ConfigurationService;
import org.parallelj.internal.conf.ParalleljConfigurationManager;
import org.parallelj.internal.conf.pojos.ParalleljConfiguration;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ListenerManager;
import org.quartz.Scheduler;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerMetaData;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.spi.JobFactory;

public class ParalleljScheduler
implements Scheduler {
    private Scheduler scheduler;
    private ParalleljConfiguration configuration;

    public ParalleljScheduler() throws SchedulerException {
        StdSchedulerFactory schedFact = new StdSchedulerFactory();
        this.scheduler = schedFact.getScheduler();
        this.initialize();
    }

    private void initialize() {
        this.configuration = (ParalleljConfiguration)((ConfigurationManager)ConfigurationService.getConfigurationService().getConfigurationManager().get(ParalleljConfigurationManager.class)).getConfiguration();
    }

    private void stop() {
    }

    public final ParalleljConfiguration getConfiguration() {
        return this.configuration;
    }

    public final String getSchedulerName() throws SchedulerException {
        return this.scheduler.getSchedulerName();
    }

    public final String getSchedulerInstanceId() throws SchedulerException {
        return this.scheduler.getSchedulerInstanceId();
    }

    public final SchedulerContext getContext() throws SchedulerException {
        return this.scheduler.getContext();
    }

    public final void start() throws SchedulerException {
        this.scheduler.start();
    }

    public final void startDelayed(int seconds) throws SchedulerException {
        this.scheduler.startDelayed(seconds);
    }

    public final boolean isStarted() throws SchedulerException {
        return this.scheduler.isStarted();
    }

    public final void standby() throws SchedulerException {
        this.scheduler.standby();
    }

    public final boolean isInStandbyMode() throws SchedulerException {
        return this.scheduler.isInStandbyMode();
    }

    public final void shutdown() throws SchedulerException {
        this.stop();
        this.scheduler.shutdown();
    }

    public final void shutdown(boolean waitForJobsToComplete) throws SchedulerException {
        this.stop();
        this.scheduler.shutdown(waitForJobsToComplete);
    }

    public final boolean isShutdown() throws SchedulerException {
        return this.scheduler.isShutdown();
    }

    public final SchedulerMetaData getMetaData() throws SchedulerException {
        return this.scheduler.getMetaData();
    }

    public final List<JobExecutionContext> getCurrentlyExecutingJobs() throws SchedulerException {
        return this.scheduler.getCurrentlyExecutingJobs();
    }

    public final void setJobFactory(JobFactory factory) throws SchedulerException {
        this.scheduler.setJobFactory(factory);
    }

    public final ListenerManager getListenerManager() throws SchedulerException {
        return this.scheduler.getListenerManager();
    }

    public final boolean unscheduleJob(TriggerKey triggerKey) throws SchedulerException {
        return this.scheduler.unscheduleJob(triggerKey);
    }

    public final boolean unscheduleJobs(List<TriggerKey> triggerKeys) throws SchedulerException {
        return this.scheduler.unscheduleJobs(triggerKeys);
    }

    public final void addJob(JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.scheduler.addJob(jobDetail, replace);
    }

    public final boolean deleteJob(JobKey jobKey) throws SchedulerException {
        return this.scheduler.deleteJob(jobKey);
    }

    public final boolean deleteJobs(List<JobKey> jobKeys) throws SchedulerException {
        return this.scheduler.deleteJobs(jobKeys);
    }

    public final void triggerJob(JobKey jobKey) throws SchedulerException {
        this.scheduler.triggerJob(jobKey);
    }

    public final void triggerJob(JobKey jobKey, JobDataMap data) throws SchedulerException {
        this.scheduler.triggerJob(jobKey, data);
    }

    public final void pauseJob(JobKey jobKey) throws SchedulerException {
        this.scheduler.pauseJob(jobKey);
    }

    public final void pauseJobs(GroupMatcher<JobKey> matcher) throws SchedulerException {
        this.scheduler.pauseJobs(matcher);
    }

    public final void pauseTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.scheduler.pauseTrigger(triggerKey);
    }

    public final void pauseTriggers(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
        this.scheduler.pauseTriggers(matcher);
    }

    public final void resumeJob(JobKey jobKey) throws SchedulerException {
        this.scheduler.resumeJob(jobKey);
    }

    public final void resumeJobs(GroupMatcher<JobKey> matcher) throws SchedulerException {
        this.scheduler.resumeJobs(matcher);
    }

    public final void resumeTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.scheduler.resumeTrigger(triggerKey);
    }

    public final void resumeTriggers(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
        this.scheduler.resumeTriggers(matcher);
    }

    public final void pauseAll() throws SchedulerException {
        this.scheduler.pauseAll();
    }

    public final void resumeAll() throws SchedulerException {
        this.scheduler.resumeAll();
    }

    public final List<String> getJobGroupNames() throws SchedulerException {
        return this.scheduler.getJobGroupNames();
    }

    public final Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws SchedulerException {
        return this.scheduler.getJobKeys(matcher);
    }

    public final List<String> getTriggerGroupNames() throws SchedulerException {
        return this.scheduler.getTriggerGroupNames();
    }

    public final Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws SchedulerException {
        return this.scheduler.getTriggerKeys(matcher);
    }

    public final Set<String> getPausedTriggerGroups() throws SchedulerException {
        return this.scheduler.getPausedTriggerGroups();
    }

    public final JobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getJobDetail(jobKey);
    }

    public final Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws SchedulerException {
        return this.scheduler.getTriggerState(triggerKey);
    }

    public final boolean deleteCalendar(String calName) throws SchedulerException {
        return this.scheduler.deleteCalendar(calName);
    }

    public final List<String> getCalendarNames() throws SchedulerException {
        return this.scheduler.getCalendarNames();
    }

    public final boolean interrupt(JobKey jobKey) throws UnableToInterruptJobException {
        return this.scheduler.interrupt(jobKey);
    }

    public final boolean interrupt(String fireInstanceId) throws UnableToInterruptJobException {
        return this.scheduler.interrupt(fireInstanceId);
    }

    public final boolean checkExists(JobKey jobKey) throws SchedulerException {
        return this.scheduler.checkExists(jobKey);
    }

    public final boolean checkExists(TriggerKey triggerKey) throws SchedulerException {
        return this.scheduler.checkExists(triggerKey);
    }

    public final void clear() throws SchedulerException {
        this.scheduler.clear();
    }

    public final void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public final Date scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        return this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public final Date scheduleJob(Trigger trigger) throws SchedulerException {
        return this.scheduler.scheduleJob(trigger);
    }

    public final void scheduleJobs(Map<JobDetail, List<Trigger>> triggersAndJobs, boolean replace) throws SchedulerException {
        this.scheduler.scheduleJobs(triggersAndJobs, replace);
    }

    public final Date rescheduleJob(TriggerKey triggerKey, Trigger newTrigger) throws SchedulerException {
        return this.scheduler.rescheduleJob(triggerKey, newTrigger);
    }

    public final List<? extends Trigger> getTriggersOfJob(JobKey jobKey) throws SchedulerException {
        return this.scheduler.getTriggersOfJob(jobKey);
    }

    public final Trigger getTrigger(TriggerKey triggerKey) throws SchedulerException {
        return this.scheduler.getTrigger(triggerKey);
    }

    public final void addCalendar(String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        this.scheduler.addCalendar(calName, calendar, replace, updateTriggers);
    }

    public final Calendar getCalendar(String calName) throws SchedulerException {
        return this.scheduler.getCalendar(calName);
    }
}

