/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.quartz;

import java.util.Collection;
import org.parallelj.launching.quartz.ParalleljScheduler;
import org.parallelj.launching.quartz.ParalleljSchedulerRepository;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;

public class ParalleljSchedulerFactory
implements SchedulerFactory {
    private StdSchedulerFactory stdChedulerFactory;

    public ParalleljSchedulerFactory() {
        this.stdChedulerFactory = new StdSchedulerFactory();
    }

    public ParalleljSchedulerFactory(String fileName) throws SchedulerException {
        this.stdChedulerFactory = new StdSchedulerFactory(fileName);
    }

    public final ParalleljScheduler getScheduler() throws SchedulerException {
        Scheduler scheduler = this.stdChedulerFactory.getScheduler();
        ParalleljSchedulerRepository pSchedRep = ParalleljSchedulerRepository.getInstance();
        ParalleljScheduler pScheduler = pSchedRep.lookup(scheduler.getSchedulerName());
        if (pScheduler != null) {
            if (!scheduler.isShutdown()) {
                return pScheduler;
            }
            pSchedRep.remove(scheduler.getSchedulerName());
            return pScheduler;
        }
        pScheduler = this.instantiate(pSchedRep, this.stdChedulerFactory);
        return pScheduler;
    }

    private ParalleljScheduler instantiate(ParalleljSchedulerRepository pSchedRep, StdSchedulerFactory stdChedulerFactory) throws SchedulerException {
        ParalleljScheduler pScheduler = new ParalleljScheduler();
        pSchedRep.bind(pScheduler);
        return pScheduler;
    }

    public final Scheduler getScheduler(String schedName) throws SchedulerException {
        return ParalleljSchedulerRepository.getInstance().lookup(schedName);
    }

    public final Collection<Scheduler> getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

