/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.quartz;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.parallelj.launching.quartz.ParalleljScheduler;
import org.quartz.SchedulerException;

public final class ParalleljSchedulerRepository {
    private HashMap<String, ParalleljScheduler> schedulers = new HashMap();
    private static ParalleljSchedulerRepository inst;

    private ParalleljSchedulerRepository() {
    }

    public static synchronized ParalleljSchedulerRepository getInstance() {
        if (inst == null) {
            inst = new ParalleljSchedulerRepository();
        }
        return inst;
    }

    public synchronized void bind(ParalleljScheduler sched) throws SchedulerException {
        if (this.schedulers.get(sched.getSchedulerName()) != null) {
            throw new SchedulerException("Scheduler with name '" + sched.getSchedulerName() + "' already exists.");
        }
        this.schedulers.put(sched.getSchedulerName(), sched);
    }

    public synchronized boolean remove(String schedName) {
        return this.schedulers.remove(schedName) != null;
    }

    public synchronized ParalleljScheduler lookup(String schedName) {
        return this.schedulers.get(schedName);
    }

    public synchronized Collection<ParalleljScheduler> lookupAll() {
        return Collections.unmodifiableCollection(this.schedulers.values());
    }
}

