/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.quartz.web;

import java.io.IOException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.mina.core.service.IoHandler;
import org.parallelj.internal.conf.ConfigurationManager;
import org.parallelj.internal.conf.ConfigurationService;
import org.parallelj.internal.conf.ParalleljConfigurationManager;
import org.parallelj.internal.conf.pojos.CBean;
import org.parallelj.internal.conf.pojos.ParalleljConfiguration;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.internal.ext.Extensions;
import org.parallelj.launching.quartz.LaunchException;
import org.parallelj.launching.quartz.Launcher;
import org.parallelj.launching.transport.jmx.JmxServer;
import org.parallelj.launching.transport.ssh.SshServer;
import org.parallelj.launching.transport.tcp.TcpIpHandlerAdapter;
import org.parallelj.launching.transport.tcp.TcpIpServer;

public class ServersInitializerListener
implements ServletContextListener {
    private TcpIpServer tcpIpServer;
    private JmxServer jmxServer;
    private SshServer sshServer;
    private static transient /* synthetic */ Extensions ajc$org_parallelj_launching_internal_ext_Extensions$ptwAspectInstance;

    public final void contextInitialized(ServletContextEvent sce) {
        ServersInitializerListener.ajc$org_parallelj_launching_internal_ext_Extensions$ptwAspectInstance.ajc$before$org_parallelj_launching_internal_ext_Extensions$1$ad0472b6(this);
        try {
            ParalleljConfiguration configuration = (ParalleljConfiguration)((ConfigurationManager)ConfigurationService.getConfigurationService().getConfigurationManager().get(ParalleljConfigurationManager.class)).getConfiguration();
            Launcher.getLauncher();
            LaunchingMessageKind.IQUARTZ0001.format(new Object[0]);
            if (configuration.getServers() != null && configuration.getServers().getTelnet() != null) {
                this.tcpIpServer = new TcpIpServer(configuration.getServers().getTelnet().getHost(), configuration.getServers().getTelnet().getPort(), (IoHandler)new TcpIpHandlerAdapter());
                if (this.tcpIpServer != null) {
                    try {
                        this.tcpIpServer.start();
                    }
                    catch (IOException e) {
                        LaunchingMessageKind.ETCPIP0001.format(e);
                    }
                }
            } else {
                LaunchingMessageKind.ETCPIP0001.format(new Object[0]);
            }
            if (configuration.getServers() != null && configuration.getServers().getJmx() != null) {
                this.jmxServer = new JmxServer(configuration.getServers().getJmx().getHost(), configuration.getServers().getJmx().getPort());
                if (this.jmxServer != null) {
                    try {
                        this.jmxServer.start();
                    }
                    catch (IOException e) {
                        LaunchingMessageKind.EJMX0001.format(e);
                    }
                }
            } else {
                LaunchingMessageKind.EJMX0001.format(new Object[0]);
            }
            if (configuration.getServers() != null && configuration.getServers().getSsh() != null) {
                this.sshServer = new SshServer(configuration.getServers().getSsh().getPort());
                if (this.sshServer != null) {
                    try {
                        this.sshServer.start();
                    }
                    catch (IOException e) {
                        LaunchingMessageKind.ESSH0001.format(e);
                    }
                }
            }
            if (configuration.getServers().getBeans() != null && configuration.getServers().getBeans().getBean() != null) {
                for (CBean bean : configuration.getServers().getBeans().getBean()) {
                    if (this.jmxServer == null) continue;
                    this.jmxServer.registerProgramAsMBean(bean.getClazz());
                }
            }
        }
        catch (LaunchException e) {
            LaunchingMessageKind.EQUARTZ0001.format(e);
        }
    }

    public final void contextDestroyed(ServletContextEvent sce) {
        if (this.tcpIpServer != null) {
            this.tcpIpServer.stop();
        }
        if (this.jmxServer != null) {
            this.jmxServer.stop();
        }
        if (this.sshServer != null) {
            try {
                this.sshServer.stop();
            }
            catch (InterruptedException e) {
                LaunchingMessageKind.ESSH0002.format(e);
            }
        }
        try {
            Launcher.getLauncher().complete();
        }
        catch (LaunchException e) {
            LaunchingMessageKind.EQUARTZ0002.format(e);
        }
    }

    public TcpIpServer getTcpIpServer() {
        return this.tcpIpServer;
    }

    public JmxServer getJmxServer() {
        return this.jmxServer;
    }

    static {
        ajc$org_parallelj_launching_internal_ext_Extensions$ptwAspectInstance = Extensions.ajc$createAspectInstance("org.parallelj.launching.quartz.web.ServersInitializerListener");
    }
}

