/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import org.apache.commons.lang3.ArrayUtils;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.inout.Argument;
import org.parallelj.launching.parser.NopParser;
import org.parallelj.launching.quartz.Launch;
import org.parallelj.launching.quartz.LaunchException;
import org.parallelj.launching.quartz.Launcher;
import org.parallelj.launching.remote.RemoteProgram;
import org.parallelj.launching.transport.jmx.JmxCommand;
import org.parallelj.launching.transport.jmx.JmxCommands;
import org.parallelj.launching.transport.jmx.JmxOption;
import org.parallelj.launching.transport.jmx.JmxOptions;
import org.quartz.JobDataMap;

public class DynamicLegacyProgram
implements DynamicMBean {
    private RemoteProgram remoteProgram;
    private JmxCommand[] cmds;
    private MBeanOperationInfo[] operations;

    public DynamicLegacyProgram(RemoteProgram remoteProgram) {
        this.remoteProgram = remoteProgram;
        this.cmds = JmxCommands.getCommands().values().toArray(new JmxCommand[0]);
        Arrays.sort(this.cmds);
        this.operations = new MBeanOperationInfo[this.cmds.length];
        int opIndex = 0;
        JmxCommand[] jmxCommandArray = this.cmds;
        int n = this.cmds.length;
        int n2 = 0;
        while (n2 < n) {
            JmxCommand cmd = jmxCommandArray[n2];
            ArrayList<MBeanParameterInfo> parameters = new ArrayList<MBeanParameterInfo>();
            for (JmxOption option : JmxOptions.getOptions()) {
                MBeanParameterInfo param = new MBeanParameterInfo(option.getName(), "java.lang.String", option.getDescription());
                parameters.add(param);
            }
            MBeanOperationInfo operation = new MBeanOperationInfo(cmd.getType(), cmd.getUsage(), (MBeanParameterInfo[])ArrayUtils.addAll((Object[])parameters.toArray(new MBeanParameterInfo[0]), (Object[])this.createMBeanParameterInfos()), "java.lang.String", 0);
            this.operations[opIndex++] = operation;
            ++n2;
        }
    }

    protected JobDataMap buildJobDataMap(JmxCommand jmxCommand, Object[] params) throws MBeanException {
        JobDataMap jobDataMap = new JobDataMap();
        try {
            int ind = 0;
            for (JmxOption option : JmxOptions.getOptions()) {
                option.process(jobDataMap, String.valueOf(params[ind++]));
            }
            for (Argument arg : this.remoteProgram.getArguments()) {
                arg.setValueUsingParser(String.valueOf(params[ind++]));
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        return jobDataMap;
    }

    @Override
    public final Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        JmxCommand curCmd = null;
        JmxCommand[] jmxCommandArray = this.cmds;
        int n = this.cmds.length;
        int n2 = 0;
        while (n2 < n) {
            JmxCommand cmd = jmxCommandArray[n2];
            if (cmd.getType().equals(actionName)) {
                curCmd = cmd;
                break;
            }
            ++n2;
        }
        boolean isSync = actionName.startsWith("sync");
        try {
            JobDataMap jobDataMap = this.buildJobDataMap(curCmd, params);
            Launch launch = Launcher.getLauncher().newLaunch(this.remoteProgram.getAdapterClass()).addDatas(jobDataMap);
            if (isSync) {
                launch.synchLaunch();
                return LaunchingMessageKind.IQUARTZ0003.getFormatedMessage(this.remoteProgram.getAdapterClass().getCanonicalName(), launch.getLaunchId(), launch.getLaunchResult().get((Object)"RETURN_CODE"), launch.getLaunchResult().get((Object)"USER_RETURN_CODE"));
            }
            launch.aSynchLaunch();
            return LaunchingMessageKind.IQUARTZ0002.getFormatedMessage(this.remoteProgram.getAdapterClass().getCanonicalName(), launch.getLaunchId());
        }
        catch (LaunchException e) {
            LaunchingMessageKind.EQUARTZ0003.format(actionName, e);
            return null;
        }
    }

    private MBeanOperationInfo[] createMBeanOperationInfo() {
        return this.operations;
    }

    @Override
    public final MBeanInfo getMBeanInfo() {
        MBeanOperationInfo[] opers = this.createMBeanOperationInfo();
        return new MBeanInfo(this.remoteProgram.getAdapterClass().getCanonicalName(), null, null, null, opers, null);
    }

    private MBeanParameterInfo[] createMBeanParameterInfos() {
        int lenght = this.remoteProgram.getArguments() != null ? this.remoteProgram.getArguments().size() : 0;
        int cpt = 0;
        MBeanParameterInfo[] result = new MBeanParameterInfo[lenght];
        if (this.remoteProgram.getArguments() != null) {
            for (Argument arg : this.remoteProgram.getArguments()) {
                String descriptionWithoutParserFormat;
                String type = null;
                String descriptionWithParserFormat = "Parser  '%s' will be used to set this parameter as it is defined in @In annotation for this field.";
                String descriptionValueValue = descriptionWithoutParserFormat = "No parser will be used for this field as it is a primitive one.";
                if (!arg.getParser().getCanonicalName().equals(NopParser.class.getCanonicalName())) {
                    descriptionValueValue = String.format(descriptionWithParserFormat, arg.getParser().getCanonicalName());
                }
                type = !arg.getType().equals(String.class) && !arg.getType().equals(Integer.TYPE) && !arg.getType().equals(Long.TYPE) && !arg.getType().equals(Boolean.TYPE) ? String.class.getCanonicalName() : arg.getType().getCanonicalName();
                result[cpt++] = new MBeanParameterInfo(arg.getName(), type, descriptionValueValue);
            }
        }
        return result;
    }

    @Override
    public final Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return null;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public final AttributeList getAttributes(String[] attributes) {
        return new AttributeList();
    }

    @Override
    public final AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }
}

