/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.parallelj.internal.reflect.ProgramAdapter;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.remote.RemoteProgram;
import org.parallelj.launching.remote.RemotePrograms;
import org.parallelj.launching.transport.jmx.DynamicLegacyProgram;

public class JmxServer {
    private static final String DEFAULT_SERVER_URL_FORMAT = "service:jmx:rmi://%s/jndi/rmi://%s:%s/server";
    private static final String DEFAULT_BEAN_NAME_FORMAT = "%s:type=%s";
    private String host;
    private int port;
    private String serverUrlFormat;
    private String beanNameFormat;
    private Registry register = null;
    private MBeanServer mbs = null;
    private JMXConnectorServer jmxConnectorServer = null;
    private List<ObjectName> beanNames = new ArrayList<ObjectName>();

    public JmxServer(String host, int port) {
        this.host = host;
        this.port = port;
        this.serverUrlFormat = DEFAULT_SERVER_URL_FORMAT;
        this.beanNameFormat = DEFAULT_BEAN_NAME_FORMAT;
    }

    public final synchronized void start() throws IOException {
        LaunchingMessageKind.IJMX0001.format(this.host, this.port);
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        String oldRmiServerName = System.getProperty("java.rmi.server.hostname");
        System.setProperty("java.rmi.server.hostname", this.host);
        this.register = LocateRegistry.createRegistry(this.port);
        if (oldRmiServerName == null) {
            Properties props = System.getProperties();
            for (Object key : props.keySet()) {
                if (!key.equals("java.rmi.server.hostname")) continue;
                props.remove(key);
                break;
            }
        } else {
            System.setProperty("java.rmi.server.hostname", oldRmiServerName);
        }
        String serviceURL = String.format(this.serverUrlFormat, this.host, this.host, this.port);
        LaunchingMessageKind.IJMX0002.format(serviceURL);
        JMXServiceURL url = new JMXServiceURL(serviceURL);
        this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbs);
        this.jmxConnectorServer.start();
    }

    public final synchronized void stop() {
        LaunchingMessageKind.IJMX0003.format(new Object[0]);
        this.unRegisterMBeans();
        try {
            if (this.jmxConnectorServer != null) {
                this.jmxConnectorServer.stop();
            }
        }
        catch (IOException iOException) {}
        try {
            UnicastRemoteObject.unexportObject(this.register, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean registerMBean(String className) {
        if (this.mbs != null && className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                String fqnName = clazz.getCanonicalName();
                String domain = fqnName.substring(0, fqnName.lastIndexOf(46));
                String type = fqnName.substring(fqnName.lastIndexOf(46) + 1);
                ObjectName objectName = new ObjectName(String.format(this.beanNameFormat, domain, type));
                if (this.mbs.isRegistered(objectName)) return true;
                LaunchingMessageKind.IJMX0004.format(objectName);
                this.mbs.registerMBean(clazz.newInstance(), objectName);
                LaunchingMessageKind.IJMX0005.format(objectName);
                return true;
            }
            catch (Exception e) {
                LaunchingMessageKind.EJMX0004.format(className, e);
                return false;
            }
        } else {
            LaunchingMessageKind.EJMX0002.format(new Object[0]);
            return false;
        }
    }

    public final boolean registerProgramAsMBean(String beanClass) {
        block11: {
            RemoteProgram remoteProgram = RemotePrograms.getRemoteProgram(beanClass);
            if (remoteProgram == null) {
                LaunchingMessageKind.EJMX0003.format(beanClass);
                return false;
            }
            if (this.mbs == null) {
                LaunchingMessageKind.EJMX0002.format(new Object[0]);
                return false;
            }
            try {
                Class<?> clazz = Class.forName(beanClass);
                String fqnName = remoteProgram.getAdapterClass().getCanonicalName();
                String domain = fqnName.substring(0, fqnName.lastIndexOf(46));
                String type = fqnName.substring(fqnName.lastIndexOf(46) + 1);
                if (Arrays.asList(clazz.getInterfaces()).contains(ProgramAdapter.Adapter.class)) {
                    DynamicLegacyProgram dprogram = new DynamicLegacyProgram(remoteProgram);
                    ObjectName objectName = new ObjectName(String.format(this.beanNameFormat, domain, type));
                    this.beanNames.add(objectName);
                    if (!this.mbs.isRegistered(objectName)) {
                        LaunchingMessageKind.IJMX0004.format(objectName);
                        this.mbs.registerMBean(dprogram, objectName);
                        LaunchingMessageKind.IJMX0005.format(objectName);
                    }
                    break block11;
                }
                LaunchingMessageKind.EJMX0003.format(clazz);
                return false;
            }
            catch (ClassNotFoundException e) {
                LaunchingMessageKind.EJMX0004.format(beanClass, e);
                return false;
            }
            catch (MalformedObjectNameException e) {
                LaunchingMessageKind.EJMX0004.format(beanClass, e);
                return false;
            }
            catch (NullPointerException e) {
                LaunchingMessageKind.EJMX0004.format(beanClass, e);
                return false;
            }
            catch (InstanceAlreadyExistsException e) {
                LaunchingMessageKind.EJMX0004.format(beanClass, e);
                return false;
            }
            catch (MBeanRegistrationException e) {
                LaunchingMessageKind.EJMX0004.format(beanClass, e);
                return false;
            }
            catch (NotCompliantMBeanException e) {
                LaunchingMessageKind.EJMX0004.format(beanClass, e);
                return false;
            }
        }
        return true;
    }

    private void unRegisterMBeans() {
        if (this.beanNames != null) {
            for (ObjectName objectName : this.beanNames) {
                try {
                    this.mbs.unregisterMBean(objectName);
                    LaunchingMessageKind.IJMX0006.format(objectName);
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
            this.beanNames.clear();
        }
    }

    public boolean isStarted() {
        return this.jmxConnectorServer.isActive();
    }
}

