/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.ssh;

import java.io.IOException;
import org.apache.sshd.common.Factory;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.transport.ssh.SshShellFactory;

public class SshServer {
    private org.apache.sshd.SshServer sshd;
    private int port;
    private boolean started = false;

    public SshServer(int port) {
        this.port = port;
        this.sshd = org.apache.sshd.SshServer.setUpDefaultServer();
        this.sshd.setPort(port);
        this.sshd.setShellFactory((Factory)new SshShellFactory());
        this.initialize(this.sshd);
    }

    private void initialize(org.apache.sshd.SshServer sshd) {
    }

    public void start() throws IOException {
        LaunchingMessageKind.ISSH0001.format(this.port);
        try {
            this.sshd.start();
            this.started = true;
            LaunchingMessageKind.ISSH0002.format(this.port);
        }
        catch (Exception e) {
            LaunchingMessageKind.ESSH0001.format(e);
        }
    }

    public void stop() throws InterruptedException {
        if (this.started) {
            LaunchingMessageKind.ISSH0003.format(new Object[0]);
            this.sshd.stop();
        }
    }

    public boolean isStarted() {
        return this.started;
    }
}

