/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.textline.TextLineDecoder;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.transport.tcp.TcpIpHandlerAdapter;
import org.parallelj.launching.transport.tcp.TcpIpTextLineEncoder;

public class TcpIpServer {
    private static final String ENCODING = "UTF-8";
    private static final int BUFFER_READER_SIZE = 2048;
    private static final int IDLE_TIME = 10;
    private final IoAcceptor acceptor = new NioSocketAcceptor();
    private String host;
    private int port;

    public TcpIpServer(String host, int port, IoHandler handler) {
        this(host, port);
        this.acceptor.setHandler(handler);
    }

    public TcpIpServer(String host, int port) {
        this.host = host;
        this.port = port;
        this.acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)new TcpIpTextLineEncoder(Charset.forName(ENCODING)), (ProtocolDecoder)new TextLineDecoder(Charset.forName(ENCODING))));
        this.acceptor.getSessionConfig().setReadBufferSize(2048);
        this.acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, 10);
    }

    public final synchronized void start() throws IOException {
        if (this.acceptor != null) {
            if (this.acceptor.getHandler() == null) {
                this.acceptor.setHandler((IoHandler)new TcpIpHandlerAdapter());
            }
            LaunchingMessageKind.ITCPIP0001.format(this.host, this.port);
            this.acceptor.bind((SocketAddress)new InetSocketAddress(this.host, this.port));
        }
    }

    public final synchronized void stop() {
        if (this.acceptor != null) {
            LaunchingMessageKind.ITCPIP0002.format(new Object[0]);
            this.acceptor.dispose(true);
        }
    }

    public void setHandler(IoHandler handler) {
        this.acceptor.setHandler(handler);
    }

    public boolean isStarted() {
        return this.acceptor.isActive();
    }
}

