/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.tcp.command;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.mina.core.session.IoSession;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.parser.ParserException;
import org.parallelj.launching.remote.RemoteProgram;
import org.parallelj.launching.transport.tcp.command.AbstractTcpCommand;
import org.parallelj.launching.transport.tcp.command.option.IIdOption;
import org.parallelj.launching.transport.tcp.command.option.IOption;
import org.parallelj.launching.transport.tcp.command.option.OptionException;

abstract class AbstractLaunchTcpCommand
extends AbstractTcpCommand {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 4;
    public static final int DEFAULT_DESC_PAD = 3;
    private List<IOption> options;

    AbstractLaunchTcpCommand() {
    }

    @Override
    public abstract String process(IoSession var1, String ... var2);

    @Override
    public abstract String getType();

    public RemoteProgram parseCommandLine(String ... args) throws ParseException, OptionException {
        List<IOption> ioptions = this.getOptions();
        Options options = new Options();
        for (IOption ioption : ioptions) {
            options.addOption(ioption.getOption());
        }
        PosixParser parser = new PosixParser();
        CommandLine cmdLine = parser.parse(options, args);
        Option[] optionArray = cmdLine.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option option = optionArray[n2];
            for (IOption ioption : this.getOptions()) {
                if (!ioption.getOption().getOpt().equals(option.getOpt())) continue;
                ioption.setOption(option);
                break;
            }
            ++n2;
        }
        IIdOption idOption = null;
        for (IOption ioption : ioptions) {
            if (!(ioption instanceof IIdOption)) continue;
            idOption = (IIdOption)ioption;
            break;
        }
        RemoteProgram remoteProgram = idOption.getProgram();
        try {
            for (IOption ioption : ioptions) {
                ioption.ckeckOption(remoteProgram);
            }
            return remoteProgram;
        }
        catch (ParserException e) {
            throw new OptionException(e.getFormatedMessage());
        }
    }

    @Override
    public List<IOption> getOptions() {
        Class<? extends IOption> iOptionClass = this.getOptionClass();
        if (iOptionClass != null && this.options == null) {
            this.options = new ArrayList<IOption>();
            ServiceLoader<? extends IOption> loader = ServiceLoader.load(iOptionClass);
            for (IOption iOption : loader) {
                this.options.add(iOption);
            }
        }
        Comparator<IOption> comparator = new Comparator<IOption>(){

            @Override
            public int compare(IOption option1, IOption option2) {
                if (option1.getOption() != null && option1.getOption().isRequired()) {
                    return -1;
                }
                if (option2.getOption() != null && option2.getOption().isRequired()) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(this.options, comparator);
        return this.options;
    }

    @Override
    public abstract Class<? extends IOption> getOptionClass();

    @Override
    public String getHelp() {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        Options options = new Options();
        for (IOption ioption : this.getOptions()) {
            options.addOption(ioption.getOption());
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("  ");
        Comparator<Option> comparator = new Comparator<Option>(){

            @Override
            public int compare(Option option1, Option option2) {
                if (option1.isRequired()) {
                    return -1;
                }
                if (option2.isRequired()) {
                    return 1;
                }
                return 0;
            }
        };
        formatter.setOptionComparator((Comparator)comparator);
        printWriter.print(String.valueOf(this.getUsage()) + "\n\r");
        formatter.printHelp(printWriter, 74, this.getType(), null, options, 4, 3, null, true);
        printWriter.flush();
        try {
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            LaunchingMessageKind.EREMOTE0009.format(e);
        }
        return ((Object)writer).toString();
    }
}

