/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.tcp.command;

import org.apache.commons.cli.ParseException;
import org.apache.mina.core.session.IoSession;
import org.parallelj.internal.reflect.ProgramAdapter;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.parser.ParserException;
import org.parallelj.launching.quartz.Launch;
import org.parallelj.launching.quartz.LaunchException;
import org.parallelj.launching.quartz.Launcher;
import org.parallelj.launching.remote.RemoteProgram;
import org.parallelj.launching.transport.jmx.JmxCommand;
import org.parallelj.launching.transport.tcp.command.AbstractLaunchTcpCommand;
import org.parallelj.launching.transport.tcp.command.RemoteCommand;
import org.parallelj.launching.transport.tcp.command.option.IAsyncLaunchOption;
import org.parallelj.launching.transport.tcp.command.option.IOption;
import org.parallelj.launching.transport.tcp.command.option.OptionException;
import org.quartz.JobDataMap;

public class AsyncLaunch
extends AbstractLaunchTcpCommand
implements JmxCommand {
    private static final int PRIORITY = 70;
    private static final String USAGE = "asynclaunch : Launches a new Program instance, and returns (asynchronous launch).";

    @Override
    public final String process(IoSession session, String ... args) {
        JobDataMap jobDataMap = new JobDataMap();
        RemoteProgram remoteProgram = null;
        try {
            remoteProgram = this.parseCommandLine(args);
            for (IOption ioption : this.getOptions()) {
                ioption.process(jobDataMap, remoteProgram);
            }
            Class<? extends ProgramAdapter.Adapter> jobClass = remoteProgram.getAdapterClass();
            Launcher launcher = Launcher.getLauncher();
            Launch launch = launcher.newLaunch(jobClass).addDatas(jobDataMap).aSynchLaunch();
            return LaunchingMessageKind.IQUARTZ0002.getFormatedMessage(jobClass.getCanonicalName(), launch.getLaunchId());
        }
        catch (ParseException e) {
            return e.getMessage();
        }
        catch (ParserException e) {
            return e.getFormatedMessage();
        }
        catch (OptionException e) {
            return e.getFormatedMessage();
        }
        catch (LaunchException e) {
            return LaunchingMessageKind.EQUARTZ0003.format(remoteProgram != null ? remoteProgram.getAdapterClass() : "unknown", e);
        }
    }

    @Override
    public String getType() {
        return RemoteCommand.asynclaunch.name();
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public int getPriorityUsage() {
        return 70;
    }

    @Override
    public Class<? extends IOption> getOptionClass() {
        return IAsyncLaunchOption.class;
    }
}

