/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.tcp.command;

import java.util.List;
import org.apache.mina.core.session.IoSession;
import org.parallelj.launching.inout.Argument;
import org.parallelj.launching.remote.RemoteProgram;
import org.parallelj.launching.remote.RemotePrograms;
import org.parallelj.launching.transport.tcp.command.AbstractTcpCommand;
import org.parallelj.launching.transport.tcp.command.RemoteCommand;
import org.parallelj.launching.transport.tcp.command.option.IOption;

public class ListPrograms
extends AbstractTcpCommand {
    private static final int PRIORITY = 90;
    private static final String USAGE = "list : Lists available programs and their associated IDs.";

    @Override
    public final String process(IoSession session, String ... args) {
        List<RemoteProgram> programs = RemotePrograms.getRemotePrograms();
        StringBuffer stb = new StringBuffer(20);
        int index = 0;
        while (index < programs.size()) {
            stb.append("id:").append(index).append(' ').append(programs.get(index).getAdapterClass().getCanonicalName()).append(" args:[");
            try {
                RemoteProgram prog = programs.get(index);
                List<Argument> programArguments = prog.getArguments();
                for (Argument argument : programArguments) {
                    stb.append(argument.getName()).append(':').append(argument.getType().getCanonicalName()).append(' ');
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            stb.append("]\n\r");
            ++index;
        }
        return stb.toString();
    }

    @Override
    public String getType() {
        return RemoteCommand.list.name();
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public int getPriorityUsage() {
        return 90;
    }

    @Override
    public Class<? extends IOption> getOptionClass() {
        return null;
    }

    @Override
    public List<IOption> getOptions() {
        return null;
    }

    @Override
    public String getHelp() {
        return String.valueOf(this.getUsage()) + "\n\r";
    }
}

