/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.transport.tcp.command.option;

import java.util.Iterator;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.inout.Argument;
import org.parallelj.launching.parser.ParserException;
import org.parallelj.launching.remote.RemoteProgram;
import org.parallelj.launching.remote.RemotePrograms;
import org.parallelj.launching.transport.tcp.command.option.IIdOption;
import org.parallelj.launching.transport.tcp.command.option.IOption;
import org.parallelj.launching.transport.tcp.command.option.OptionException;
import org.quartz.JobDataMap;

public final class OptionsUtils {
    private OptionsUtils() {
    }

    public static void processId(IOption ioption, JobDataMap jobDataMap) throws OptionException {
        String strId = null;
        try {
            strId = ioption.getOption().getValue("id");
            int id = Integer.parseInt(strId);
            if (id >= RemotePrograms.getRemotePrograms().size()) {
                throw new OptionException(LaunchingMessageKind.EREMOTE0004.format(strId));
            }
        }
        catch (NumberFormatException e) {
            throw new OptionException(LaunchingMessageKind.EREMOTE0008.format("id", strId), e);
        }
    }

    public static void processArgs(IOption ioption, JobDataMap jobDataMap, Object ... args) throws OptionException, ParserException {
        String[] arguments = ioption.getOption().getValues();
        RemoteProgram remoteProgram = (RemoteProgram)args[0];
        if (arguments != null) {
            if (remoteProgram.getArguments().size() > arguments.length) {
                throw new OptionException(LaunchingMessageKind.EREMOTE0005.format(remoteProgram.getAdapterClass(), arguments.length));
            }
            OptionsUtils.initializeArg(remoteProgram, arguments, jobDataMap);
        }
    }

    public static void initializeArg(RemoteProgram remoteProgram, String[] arguments, JobDataMap jobDataMap) throws OptionException, ParserException {
        String argument;
        int numberOfEquals = 0;
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            argument = stringArray[n2];
            if (argument.indexOf(61) > -1) {
                ++numberOfEquals;
            }
            ++n2;
        }
        if (numberOfEquals != arguments.length) {
            throw new OptionException(LaunchingMessageKind.WREMOTE001.format(remoteProgram.getClass().getCanonicalName()));
        }
        stringArray = arguments;
        n = arguments.length;
        n2 = 0;
        while (n2 < n) {
            argument = stringArray[n2];
            if (argument.indexOf("=") > 0) {
                String[] arg = argument.split("=");
                String argName = arg[0];
                String argValue = null;
                if (arg.length > 1) {
                    argValue = arg[1];
                }
                if (argValue != null && argValue.trim().length() == 0) {
                    argValue = null;
                }
                if (argValue != null && argValue.charAt(0) == '\"' && argValue.charAt(argValue.length() - 1) == '\"') {
                    argValue = argValue.substring(1, argValue.length() - 1);
                }
                if (argValue != null && argValue.charAt(0) == '\'' && argValue.charAt(argValue.length() - 1) == '\'') {
                    argValue = argValue.substring(1, argValue.length() - 1);
                }
                if (argValue != null && argValue.equals("''")) {
                    argValue = "";
                }
                Iterator<Argument> argumentIterator = remoteProgram.getArguments().iterator();
                boolean found = false;
                while (argumentIterator.hasNext() && !found) {
                    Argument a = argumentIterator.next();
                    try {
                        if (!a.getName().equals(argName)) continue;
                        a.setValueUsingParser(argValue);
                        found = true;
                    }
                    catch (Exception e) {
                        throw new OptionException(LaunchingMessageKind.EREMOTE0010.format(a.getName(), remoteProgram.getClass().getCanonicalName()), e);
                    }
                }
                if (!found) {
                    throw new OptionException(LaunchingMessageKind.EREMOTE0012.format(argument, remoteProgram.getClass().getCanonicalName(), argument));
                }
            } else {
                throw new OptionException(LaunchingMessageKind.EREMOTE0011.format(remoteProgram.getClass().getCanonicalName()));
            }
            ++n2;
        }
    }

    public static void checkArgs(IOption ioption, RemoteProgram remoteProgram) throws OptionException {
        if (ioption.getOption().getLongOpt().equals("args") && remoteProgram.getArguments().size() > 0 && (ioption.getOption().getValues() == null || ioption.getOption().getValues().length < remoteProgram.getArguments().size())) {
            throw new OptionException(LaunchingMessageKind.EREMOTE0005.format(remoteProgram.getAdapterClass().getCanonicalName(), remoteProgram.getArguments().size()));
        }
    }

    public static int checkId(String str) throws OptionException {
        int index = 0;
        try {
            index = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OptionException(LaunchingMessageKind.EREMOTE0006.format(str));
        }
        return index;
    }

    public static RemoteProgram getProgram(IIdOption iIdOption) throws OptionException {
        int index = OptionsUtils.checkId(iIdOption.getOption().getValue());
        try {
            RemoteProgram remoteProgram = RemotePrograms.getRemotePrograms().get(index);
            return remoteProgram;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new OptionException(LaunchingMessageKind.EREMOTE0004.format(index));
        }
    }
}

