/*
 * Decompiled with CFR 0.152.
 */
package org.parallelj.launching.usercode;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.parallelj.Programs;
import org.parallelj.internal.kernel.KProgram;
import org.parallelj.internal.reflect.ProgramAdapter;
import org.parallelj.launching.LaunchingMessageKind;
import org.parallelj.launching.ProgramReturnCodes;
import org.parallelj.launching.internal.AbstractLaunchingListener;
import org.parallelj.launching.usercode.IUserReturnCode;
import org.parallelj.launching.usercode.UserCodeManagement;
import org.parallelj.mirror.ProgramType;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class UserCodeLaunchingListener
extends AbstractLaunchingListener {
    @Override
    public void prepareLaunching(ProgramAdapter.Adapter adapter, Programs.ProcessHelper<?> processHelper, JobExecutionContext context) throws Exception {
        context.getJobDetail().getJobDataMap();
    }

    @Override
    public void finalizeLaunching(ProgramAdapter.Adapter adapter, Programs.ProcessHelper<?> processHelper, JobExecutionContext context) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        ProgramType programType = processHelper.getProcess().getProgram();
        IUserReturnCode errorCodeP = (IUserReturnCode)programType;
        if (programType instanceof KProgram) {
            Method getterErrorMethod = UserCodeManagement.ajc$interMethodDispatch1$org_parallelj_launching_usercode_UserCodeManagement$org_parallelj_launching_usercode_IUserReturnCode$getUserReturnCodeGetterMethod(errorCodeP);
            try {
                Object userReturnCode = "";
                if (getterErrorMethod != null) {
                    userReturnCode = getterErrorMethod.invoke((Object)adapter, new Object[0]);
                }
                jobDataMap.put("USER_RETURN_CODE", userReturnCode);
                if (context.getResult() instanceof JobDataMap) {
                    ((JobDataMap)context.getResult()).put("USER_RETURN_CODE", userReturnCode);
                }
            }
            catch (IllegalAccessException e) {
                jobDataMap.put("RETURN_CODE", (Object)ProgramReturnCodes.FAILURE);
                LaunchingMessageKind.EREMOTE0009.format(e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                jobDataMap.put("RETURN_CODE", (Object)ProgramReturnCodes.FAILURE);
                LaunchingMessageKind.EREMOTE0009.format(e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                jobDataMap.put("RETURN_CODE", (Object)ProgramReturnCodes.FAILURE);
                LaunchingMessageKind.EREMOTE0009.format(e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (NullPointerException e) {
                jobDataMap.put("RETURN_CODE", (Object)ProgramReturnCodes.FAILURE);
                LaunchingMessageKind.EREMOTE0009.format(e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (ExceptionInInitializerError e) {
                jobDataMap.put("RETURN_CODE", (Object)ProgramReturnCodes.FAILURE);
                LaunchingMessageKind.EREMOTE0009.format(e);
                throw new JobExecutionException((Throwable)e);
            }
        }
    }

    @Override
    public int getPriority() {
        return 80;
    }
}

