/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.coverage.api.impl;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.launcher.TestPlan;
import org.partiql.coverage.api.impl.ConfigurationParameter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\u000b"}, d2={"Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor;", "", "()V", "extract", "Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$ConfigParams;", "testPlan", "Lorg/junit/platform/launcher/TestPlan;", "extract$partiql_coverage", "ConfigParamWrapper", "ConfigParams", "LcovConfig", "partiql-coverage"})
public final class ConfigurationParameterExtractor {
    @NotNull
    public static final ConfigurationParameterExtractor INSTANCE = new ConfigurationParameterExtractor();

    private ConfigurationParameterExtractor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ConfigParams extract$partiql_coverage(@NotNull TestPlan testPlan) {
        LcovConfig lcovConfig;
        LcovConfig lcovConfig2;
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        ConfigurationParameters configurationParameters = testPlan.getConfigurationParameters();
        Intrinsics.checkNotNullExpressionValue((Object)configurationParameters, (String)"testPlan.configurationParameters");
        ConfigParamWrapper config = new ConfigParamWrapper(configurationParameters);
        String string = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_ENABLED);
        if (string != null) {
            String it = string;
            boolean bl = false;
            boolean bl2 = Boolean.parseBoolean(it);
            if (!bl2) {
                lcovConfig2 = null;
            } else {
                if (!bl2) throw new NoWhenBranchMatchedException();
                String string2 = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_REPORT_LOCATION);
                if (string2 == null) {
                    throw new IllegalStateException(("Expected to find a report path (specified by \"" + ConfigurationParameter.LCOV_BRANCH_REPORT_LOCATION.getKey() + "\").").toString());
                }
                String reportPath = string2;
                String htmlOutputDir = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_HTML_DIR);
                String string3 = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_MINIMUM);
                Double branchMinimum = string3 != null ? Double.valueOf(Double.parseDouble(string3)) : null;
                lcovConfig2 = new LcovConfig(reportPath, htmlOutputDir, branchMinimum);
            }
        } else {
            lcovConfig2 = null;
        }
        LcovConfig lcovBranchConfig = lcovConfig2;
        String string4 = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_CONDITION_ENABLED);
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            boolean bl3 = Boolean.parseBoolean(it);
            if (!bl3) {
                lcovConfig = null;
            } else {
                if (!bl3) throw new NoWhenBranchMatchedException();
                String string5 = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_CONDITION_REPORT_LOCATION);
                if (string5 == null) {
                    throw new IllegalStateException(("Expected to find a report path (specified by \"" + ConfigurationParameter.LCOV_BRANCH_CONDITION_REPORT_LOCATION.getKey() + "\").").toString());
                }
                String reportPath = string5;
                String htmlOutputDir = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_CONDITION_HTML_DIR);
                String string6 = config.getConfigParam(ConfigurationParameter.LCOV_BRANCH_CONDITION_MINIMUM);
                Double branchMinimum = string6 != null ? Double.valueOf(Double.parseDouble(string6)) : null;
                lcovConfig = new LcovConfig(reportPath, htmlOutputDir, branchMinimum);
            }
        } else {
            lcovConfig = null;
        }
        LcovConfig lcovConditionConfig = lcovConfig;
        return new ConfigParams(lcovBranchConfig, lcovConditionConfig);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$ConfigParams;", "", "lcovBranchConfig", "Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$LcovConfig;", "lcovConditionConfig", "(Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$LcovConfig;Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$LcovConfig;)V", "getLcovBranchConfig", "()Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$LcovConfig;", "getLcovConditionConfig", "partiql-coverage"})
    public static final class ConfigParams {
        @Nullable
        private final LcovConfig lcovBranchConfig;
        @Nullable
        private final LcovConfig lcovConditionConfig;

        public ConfigParams(@Nullable LcovConfig lcovBranchConfig, @Nullable LcovConfig lcovConditionConfig) {
            this.lcovBranchConfig = lcovBranchConfig;
            this.lcovConditionConfig = lcovConditionConfig;
        }

        @Nullable
        public final LcovConfig getLcovBranchConfig() {
            return this.lcovBranchConfig;
        }

        @Nullable
        public final LcovConfig getLcovConditionConfig() {
            return this.lcovConditionConfig;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$LcovConfig;", "", "reportPath", "", "htmlOutputDir", "minimum", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Double;)V", "getHtmlOutputDir", "()Ljava/lang/String;", "getMinimum", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getReportPath", "partiql-coverage"})
    public static final class LcovConfig {
        @NotNull
        private final String reportPath;
        @Nullable
        private final String htmlOutputDir;
        @Nullable
        private final Double minimum;

        public LcovConfig(@NotNull String reportPath, @Nullable String htmlOutputDir, @Nullable Double minimum) {
            Intrinsics.checkNotNullParameter((Object)reportPath, (String)"reportPath");
            this.reportPath = reportPath;
            this.htmlOutputDir = htmlOutputDir;
            this.minimum = minimum;
        }

        @NotNull
        public final String getReportPath() {
            return this.reportPath;
        }

        @Nullable
        public final String getHtmlOutputDir() {
            return this.htmlOutputDir;
        }

        @Nullable
        public final Double getMinimum() {
            return this.minimum;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/partiql/coverage/api/impl/ConfigurationParameterExtractor$ConfigParamWrapper;", "", "params", "Lorg/junit/platform/engine/ConfigurationParameters;", "(Lorg/junit/platform/engine/ConfigurationParameters;)V", "getParams", "()Lorg/junit/platform/engine/ConfigurationParameters;", "getConfigParam", "", "param", "Lorg/partiql/coverage/api/impl/ConfigurationParameter;", "partiql-coverage"})
    private static final class ConfigParamWrapper {
        @NotNull
        private final ConfigurationParameters params;

        public ConfigParamWrapper(@NotNull ConfigurationParameters params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.params = params;
        }

        @NotNull
        public final ConfigurationParameters getParams() {
            return this.params;
        }

        @Nullable
        public final String getConfigParam(@NotNull ConfigurationParameter param) {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)param), (String)"param");
            Optional value = this.params.get(param.getKey());
            boolean bl = value.isPresent();
            if (bl) {
                string = (String)value.get();
            } else if (!bl) {
                string = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
    }
}

