/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.coverage.api.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.RandomKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.partiql.coverage.api.impl.ConfigurationParameterExtractor;
import org.partiql.coverage.api.impl.ReportKey;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b \u0018\u00002\u00020\u0001:\u0004*+,-B\u0005\u00a2\u0006\u0002\u0010\u0002JT\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u0017H&J\b\u0010\u0018\u001a\u00020\u0004H&J\b\u0010\u0019\u001a\u00020\u0004H&J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\b\u0010\u001c\u001a\u00020\u001dH&J\u001c\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0012\u0010$\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010'\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0018\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/partiql/coverage/api/impl/LcovReportListener;", "Lorg/junit/platform/launcher/TestExecutionListener;", "()V", "destinationFileName", "", "reportFile", "Ljava/io/File;", "reportStream", "Ljava/io/OutputStream;", "getCoverageInformationEntry", "testName", "filePath", "branchesFound", "", "branchesHit", "linesFound", "linesHit", "branches", "", "Lorg/partiql/coverage/api/impl/LcovReportListener$Branch;", "lineData", "Lorg/partiql/coverage/api/impl/LcovReportListener$LineData;", "getCoverageTargetType", "Lorg/partiql/coverage/api/impl/ReportKey$CoverageTarget;", "getReportPath", "getTargetCountKey", "initializeOutputFile", "file", "isLcovEnabled", "", "reportingEntryPublished", "", "testIdentifier", "Lorg/junit/platform/launcher/TestIdentifier;", "entry", "Lorg/junit/platform/engine/reporting/ReportEntry;", "testPlanExecutionFinished", "testPlan", "Lorg/junit/platform/launcher/TestPlan;", "testPlanExecutionStarted", "writePartiQLToFile", "stmt", "Branch", "LcovReportBranchListener", "LcovReportConditionListener", "LineData", "partiql-coverage"})
public abstract class LcovReportListener
implements TestExecutionListener {
    private OutputStream reportStream;
    private String destinationFileName;
    private File reportFile;

    public abstract boolean isLcovEnabled();

    @NotNull
    public abstract String getReportPath();

    @NotNull
    public abstract String getTargetCountKey();

    @NotNull
    public abstract ReportKey.CoverageTarget getCoverageTargetType();

    public void testPlanExecutionStarted(@Nullable TestPlan testPlan) {
        if (testPlan == null) {
            super.testPlanExecutionStarted(testPlan);
            return;
        }
        boolean bl = this.isLcovEnabled();
        if (bl) {
            File file;
            this.destinationFileName = this.getReportPath();
            String string = this.destinationFileName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"destinationFileName");
                string = null;
            }
            if ((file = (this.reportFile = new File(string))) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"reportFile");
                file = null;
            }
            this.reportStream = this.initializeOutputFile(file);
        } else if (!bl) {
            OutputStream outputStream = OutputStream.nullOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"nullOutputStream()");
            this.reportStream = outputStream;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void reportingEntryPublished(@Nullable TestIdentifier testIdentifier, @Nullable ReportEntry entry) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object element$iv2;
        Object object;
        void $this$mapTo$iv$iv;
        Object it;
        Object $this$filterTo$iv$iv2;
        String string;
        String packageName;
        String string2;
        String originalStatement;
        Map map;
        String string3;
        if (!this.isLcovEnabled()) {
            super.reportingEntryPublished(testIdentifier, entry);
            return;
        }
        ReportEntry reportEntry = entry;
        Map map2 = reportEntry != null ? reportEntry.getKeyValuePairs() : null;
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        if ((string3 = (String)(map = map2).get("$pql-os")) == null) {
            string3 = originalStatement = "";
        }
        if ((string2 = (String)map.get("$pql-pan")) == null || (string2 = StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null)) == null) {
            string2 = packageName = "PQL_NO_PACKAGE_FOUND";
        }
        if ((string = (String)map.get("$pql-prn")) == null) {
            string = "PQL_NO_PROVIDER_FOUND_" + RandomKt.Random((int)5).nextLong();
        }
        String providerName = string;
        String string4 = (String)map.get(this.getTargetCountKey());
        int branchCount = string4 != null ? Integer.parseInt(string4) : 0;
        Map branchToLineMap = new LinkedHashMap();
        Map branchResults = new LinkedHashMap();
        Map $this$filter$iv2 = map;
        boolean $i$f$filter = false;
        Map map3 = $this$filter$iv2;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv2.entrySet()) {
            it = element$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            if (!StringsKt.startsWith$default((String)((String)k), (String)"$pql-ct", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv2 = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv2.entrySet()) {
            it = element$iv$iv;
            boolean bl = false;
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            if (!(ReportKey.CoverageTarget.valueOf((String)v) == this.getCoverageTargetType())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $this$map$iv = destination$iv$iv.keySet();
        boolean $i$f$map = false;
        $this$filterTo$iv$iv2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)((Object)item$iv$iv);
            object = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            String[] stringArray = new String[]{"::"};
            object.add((String)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1));
        }
        Set targetIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List lcovBranches = new ArrayList();
        Set lcovLineData = new LinkedHashSet();
        long executedCount = 0L;
        Iterable $this$forEach$iv = targetIds;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String string5;
            String outcome;
            String targetId = (String)element$iv2;
            boolean bl = false;
            String string6 = (String)map.get("$pql-lft::" + targetId);
            long lineNum = string6 != null ? Long.parseLong(string6) : 1L;
            String string7 = (String)map.get("$pql-oft::" + targetId);
            if (string7 == null) {
                string7 = outcome = "UNKNOWN_OUTCOME";
            }
            if ((string5 = (String)map.get("$pql-tft::" + targetId)) == null) {
                string5 = "UNKNOWN_TYPE";
            }
            String type = string5;
            String targetName = type + "::" + outcome + "::" + targetId;
            String string8 = (String)map.get("$pql-rob::" + targetId);
            long count = string8 != null ? Long.parseLong(string8) : 0L;
            executedCount += count;
            Long l = count;
            branchResults.put(targetName, l);
            l = lineNum;
            branchToLineMap.put(targetName, l);
            lcovBranches.add(new Branch(targetName, count, lineNum));
            lcovLineData.add(new LineData(lineNum, 1L));
        }
        String uniqueFileName = providerName + ".pql";
        File file = this.reportFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportFile");
            file = null;
        }
        File file2 = file.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"reportFile.parentFile");
        File queryPath = FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)file2, (String)"source"), (String)packageName), (String)uniqueFileName);
        this.writePartiQLToFile(originalStatement, queryPath);
        TestIdentifier testIdentifier2 = testIdentifier;
        String string9 = testIdentifier2 != null ? testIdentifier2.getUniqueId() : null;
        if (string9 == null) {
            string9 = "NO_TEST_NAME";
        }
        String string10 = queryPath.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"queryPath.absolutePath");
        element$iv2 = lcovBranches;
        int n = branchCount;
        String string11 = string10;
        String string12 = string9;
        object = this;
        boolean $i$f$filter2 = false;
        void bl = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Branch it2 = (Branch)element$iv$iv;
            boolean bl2 = false;
            if (!(it2.getCount() > 0L)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        String coverageEntry = super.getCoverageInformationEntry(string12, string11, n, list.size(), lcovLineData.size(), lcovLineData.size(), lcovBranches, lcovLineData);
        OutputStream outputStream = this.reportStream;
        if (outputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportStream");
            outputStream = null;
        }
        String string13 = coverageEntry;
        byte[] byArray = string13.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        outputStream.write(byArray);
    }

    public void testPlanExecutionFinished(@Nullable TestPlan testPlan) {
        OutputStream outputStream = this.reportStream;
        if (outputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportStream");
            outputStream = null;
        }
        outputStream.flush();
        OutputStream outputStream2 = this.reportStream;
        if (outputStream2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportStream");
            outputStream2 = null;
        }
        outputStream2.close();
    }

    private final OutputStream initializeOutputFile(File file) {
        file.getParentFile().mkdirs();
        return new FileOutputStream(file);
    }

    private final void writePartiQLToFile(String stmt, File file) {
        file.getParentFile().mkdirs();
        String string = stmt;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        FilesKt.writeBytes((File)file, (byte[])byArray);
    }

    private final String getCoverageInformationEntry(String testName, String filePath, int branchesFound, int branchesHit, int linesFound, int linesHit, Iterable<Branch> branches, Iterable<LineData> lineData) {
        StringBuilder strBuilder = new StringBuilder();
        StringBuilder stringBuilder = strBuilder.append("TN:" + testName);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder2 = strBuilder.append("SF:" + filePath);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        int block = 0;
        Iterable<Object> $this$forEach$iv = branches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Branch branch = element$iv;
            boolean bl = false;
            StringBuilder stringBuilder3 = strBuilder.append("BRDA:" + branch.getLine() + ',' + block + ',' + branch.getName() + ',' + branch.getCount());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder4 = strBuilder.append("BRF:" + branchesFound);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder5 = strBuilder.append("BRH:" + branchesHit);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        $this$forEach$iv = lineData;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineData line = (LineData)element$iv;
            boolean bl = false;
            StringBuilder stringBuilder6 = strBuilder.append("DA:" + line.getLine() + ',' + line.getExecutionCount());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
        }
        StringBuilder stringBuilder7 = strBuilder.append("LH:" + linesHit);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder8 = strBuilder.append("LF:" + linesFound);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder9 = strBuilder.append("end_of_record");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append('\\n')");
        String string = strBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"strBuilder.toString()");
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/partiql/coverage/api/impl/LcovReportListener$Branch;", "", "name", "", "count", "", "line", "(Ljava/lang/String;JJ)V", "getCount", "()J", "getLine", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "partiql-coverage"})
    private static final class Branch {
        @NotNull
        private final String name;
        private final long count;
        private final long line;

        public Branch(@NotNull String name, long count, long line) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.count = count;
            this.line = line;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getCount() {
            return this.count;
        }

        public final long getLine() {
            return this.line;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final long component2() {
            return this.count;
        }

        public final long component3() {
            return this.line;
        }

        @NotNull
        public final Branch copy(@NotNull String name, long count, long line) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Branch(name, count, line);
        }

        public static /* synthetic */ Branch copy$default(Branch branch, String string, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = branch.name;
            }
            if ((n & 2) != 0) {
                l = branch.count;
            }
            if ((n & 4) != 0) {
                l2 = branch.line;
            }
            return branch.copy(string, l, l2);
        }

        @NotNull
        public String toString() {
            return "Branch(name=" + this.name + ", count=" + this.count + ", line=" + this.line + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + Long.hashCode(this.count);
            result = result * 31 + Long.hashCode(this.line);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Branch)) {
                return false;
            }
            Branch branch = (Branch)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)branch.name)) {
                return false;
            }
            if (this.count != branch.count) {
                return false;
            }
            return this.line == branch.line;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/partiql/coverage/api/impl/LcovReportListener$LineData;", "", "line", "", "executionCount", "(JJ)V", "getExecutionCount", "()J", "getLine", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "partiql-coverage"})
    private static final class LineData {
        private final long line;
        private final long executionCount;

        public LineData(long line, long executionCount) {
            this.line = line;
            this.executionCount = executionCount;
        }

        public final long getLine() {
            return this.line;
        }

        public final long getExecutionCount() {
            return this.executionCount;
        }

        public final long component1() {
            return this.line;
        }

        public final long component2() {
            return this.executionCount;
        }

        @NotNull
        public final LineData copy(long line, long executionCount) {
            return new LineData(line, executionCount);
        }

        public static /* synthetic */ LineData copy$default(LineData lineData, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = lineData.line;
            }
            if ((n & 2) != 0) {
                l2 = lineData.executionCount;
            }
            return lineData.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "LineData(line=" + this.line + ", executionCount=" + this.executionCount + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.line);
            result = result * 31 + Long.hashCode(this.executionCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineData)) {
                return false;
            }
            LineData lineData = (LineData)other;
            if (this.line != lineData.line) {
                return false;
            }
            return this.executionCount == lineData.executionCount;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/partiql/coverage/api/impl/LcovReportListener$LcovReportConditionListener;", "Lorg/partiql/coverage/api/impl/LcovReportListener;", "()V", "isLcovEnabled", "", "reportPath", "", "getCoverageTargetType", "Lorg/partiql/coverage/api/impl/ReportKey$CoverageTarget;", "getReportPath", "getTargetCountKey", "testPlanExecutionStarted", "", "testPlan", "Lorg/junit/platform/launcher/TestPlan;", "partiql-coverage"})
    public static final class LcovReportConditionListener
    extends LcovReportListener {
        private boolean isLcovEnabled;
        @Nullable
        private String reportPath;

        @Override
        public boolean isLcovEnabled() {
            return this.isLcovEnabled;
        }

        @Override
        @NotNull
        public String getReportPath() {
            String string = this.reportPath;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        public String getTargetCountKey() {
            return "$pql-bcc";
        }

        @Override
        @NotNull
        public ReportKey.CoverageTarget getCoverageTargetType() {
            return ReportKey.CoverageTarget.BRANCH_CONDITION;
        }

        @Override
        public void testPlanExecutionStarted(@Nullable TestPlan testPlan) {
            if (testPlan == null) {
                super.testPlanExecutionStarted(testPlan);
                return;
            }
            ConfigurationParameterExtractor.ConfigParams configParams = ConfigurationParameterExtractor.INSTANCE.extract$partiql_coverage(testPlan);
            this.isLcovEnabled = configParams.getLcovConditionConfig() != null;
            ConfigurationParameterExtractor.LcovConfig lcovConfig = configParams.getLcovConditionConfig();
            this.reportPath = lcovConfig != null ? lcovConfig.getReportPath() : null;
            super.testPlanExecutionStarted(testPlan);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/partiql/coverage/api/impl/LcovReportListener$LcovReportBranchListener;", "Lorg/partiql/coverage/api/impl/LcovReportListener;", "()V", "isLcovEnabled", "", "reportPath", "", "getCoverageTargetType", "Lorg/partiql/coverage/api/impl/ReportKey$CoverageTarget;", "getReportPath", "getTargetCountKey", "testPlanExecutionStarted", "", "testPlan", "Lorg/junit/platform/launcher/TestPlan;", "partiql-coverage"})
    public static final class LcovReportBranchListener
    extends LcovReportListener {
        private boolean isLcovEnabled;
        @Nullable
        private String reportPath;

        @Override
        public boolean isLcovEnabled() {
            return this.isLcovEnabled;
        }

        @Override
        @NotNull
        public String getReportPath() {
            String string = this.reportPath;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        public String getTargetCountKey() {
            return "$pql-bc";
        }

        @Override
        @NotNull
        public ReportKey.CoverageTarget getCoverageTargetType() {
            return ReportKey.CoverageTarget.BRANCH;
        }

        @Override
        public void testPlanExecutionStarted(@Nullable TestPlan testPlan) {
            if (testPlan == null) {
                super.testPlanExecutionStarted(testPlan);
                return;
            }
            ConfigurationParameterExtractor.ConfigParams configParams = ConfigurationParameterExtractor.INSTANCE.extract$partiql_coverage(testPlan);
            this.isLcovEnabled = configParams.getLcovBranchConfig() != null;
            ConfigurationParameterExtractor.LcovConfig lcovConfig = configParams.getLcovBranchConfig();
            this.reportPath = lcovConfig != null ? lcovConfig.getReportPath() : null;
            super.testPlanExecutionStarted(testPlan);
        }
    }
}

