/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.coverage.api.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.coverage.api.impl.ThresholdException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/partiql/coverage/api/impl/ThresholdExecutor;", "", "()V", "computeBranchCoverage", "", "reportPath", "", "execute", "", "minimum", "type", "Lorg/partiql/coverage/api/impl/ThresholdException$ThresholdType;", "execute$partiql_coverage", "partiql-coverage"})
public final class ThresholdExecutor {
    @NotNull
    public static final ThresholdExecutor INSTANCE = new ThresholdExecutor();

    private ThresholdExecutor() {
    }

    public final void execute$partiql_coverage(double minimum, @NotNull String reportPath, @NotNull ThresholdException.ThresholdType type) throws ThresholdException {
        Intrinsics.checkNotNullParameter((Object)reportPath, (String)"reportPath");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        double coverage = this.computeBranchCoverage(reportPath);
        if (coverage < minimum) {
            throw new ThresholdException(minimum, coverage, type);
        }
    }

    private final double computeBranchCoverage(String reportPath) {
        File file;
        File file2 = file = new File(reportPath);
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object object = file2;
        BufferedReader lineReader = (object = (Reader)new InputStreamReader((InputStream)new FileInputStream((File)object), charset)) instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        String line = lineReader.readLine();
        int branchesFound = 0;
        int branchesHit = 0;
        while (line != null) {
            int n2;
            if (StringsKt.startsWith$default((String)line, (String)"BRF:", (boolean)false, (int)2, null)) {
                object = line;
                n2 = 4;
                String string = ((String)object).substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                branchesFound += Integer.parseInt(string);
            }
            if (StringsKt.startsWith$default((String)line, (String)"BRH:", (boolean)false, (int)2, null)) {
                object = line;
                n2 = 4;
                String string = ((String)object).substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                branchesHit += Integer.parseInt(string);
            }
            line = lineReader.readLine();
        }
        lineReader.close();
        return (double)branchesHit / (double)branchesFound;
    }
}

