/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.parser.impl.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.value.datetime.Date;
import org.partiql.value.datetime.DateTimeException;
import org.partiql.value.datetime.DateTimeValue;
import org.partiql.value.datetime.Time;
import org.partiql.value.datetime.TimeZone;
import org.partiql.value.datetime.Timestamp;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/partiql/parser/impl/util/DateTimeUtils;", "", "()V", "DATE_PATTERN", "Ljava/util/regex/Pattern;", "RFC8889_TIMESTAMP_DATE_TIME_DELIMITER", "Lkotlin/text/Regex;", "SQL_TIMESTAMP_DATE_TIME_DELIMITER", "TIMESTAMP_PATTERN", "TIME_PATTERN", "getTimeZoneComponent", "Lorg/partiql/value/datetime/TimeZone;", "timezone", "", "parseDateLiteral", "Lorg/partiql/value/datetime/Date;", "dateString", "parseDateLiteral$partiql_parser", "parseTimeLiteral", "Lorg/partiql/value/datetime/Time;", "timeString", "parseTimeLiteral$partiql_parser", "parseTimestamp", "Lorg/partiql/value/datetime/Timestamp;", "timestampString", "partiql-parser"})
public final class DateTimeUtils {
    @NotNull
    public static final DateTimeUtils INSTANCE = new DateTimeUtils();
    @NotNull
    private static final Pattern DATE_PATTERN;
    @NotNull
    private static final Pattern TIME_PATTERN;
    @NotNull
    private static final Regex SQL_TIMESTAMP_DATE_TIME_DELIMITER;
    @NotNull
    private static final Regex RFC8889_TIMESTAMP_DATE_TIME_DELIMITER;
    @NotNull
    private static final Pattern TIMESTAMP_PATTERN;

    private DateTimeUtils() {
    }

    @NotNull
    public final Date parseDateLiteral$partiql_parser(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        Matcher matcher = DATE_PATTERN.matcher(dateString);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"DATE_PATTERN.matcher(dateString)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expected Date Format to be in YYYY-MM-DD, received " + dateString, null, 2, null);
        }
        String string = matcher2.group("year");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"year\")");
        int year = Integer.parseInt(string);
        String string2 = matcher2.group("month");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(\"month\")");
        int month = Integer.parseInt(string2);
        String string3 = matcher2.group("day");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(\"day\")");
        int day = Integer.parseInt(string3);
        return DateTimeValue.date((int)year, (int)month, (int)day);
    }

    @NotNull
    public final Time parseTimeLiteral$partiql_parser(@NotNull String timeString) {
        Intrinsics.checkNotNullParameter((Object)timeString, (String)"timeString");
        Matcher matcher = TIME_PATTERN.matcher(timeString);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"TIME_PATTERN.matcher(timeString)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expect TIME Format to be in HH-mm-ss.ddd+[+|-][hh:mm|z], received " + timeString, null, 2, null);
        }
        try {
            String timeZoneString;
            BigDecimal bigDecimal;
            String string = matcher2.group("hour");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"hour\")");
            int hour = Integer.parseInt(string);
            String string2 = matcher2.group("minute");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(\"minute\")");
            int minute = Integer.parseInt(string2);
            String string3 = matcher2.group("second");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(\"second\")");
            long wholeSecond = Long.parseLong(string3);
            String string4 = matcher2.group("fraction");
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                bigDecimal = new BigDecimal('.' + it);
            } else {
                bigDecimal = BigDecimal.ZERO;
            }
            BigDecimal fractionPart = bigDecimal;
            BigDecimal second = BigDecimal.valueOf(wholeSecond).add(fractionPart);
            String string5 = matcher2.group("timezone");
            if (string5 == null) {
                string5 = null;
            }
            if ((timeZoneString = string5) != null) {
                String string6 = matcher2.group("utc");
                if (string6 != null) {
                    String it = string6;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)second, (String)"second");
                    return DateTimeValue.INSTANCE.time(hour, minute, second, (TimeZone)TimeZone.UtcOffset.Companion.of(0));
                }
                TimeZone timeZone = this.getTimeZoneComponent(timeZoneString);
                Intrinsics.checkNotNullExpressionValue((Object)second, (String)"second");
                return DateTimeValue.INSTANCE.time(hour, minute, second, timeZone);
            }
            Intrinsics.checkNotNullExpressionValue((Object)second, (String)"second");
            return DateTimeValue.time$default((DateTimeValue)DateTimeValue.INSTANCE, (int)hour, (int)minute, (BigDecimal)second, null, (int)8, null);
        }
        catch (IllegalStateException e) {
            throw new DateTimeException(e.getLocalizedMessage(), null, 2, null);
        }
        catch (IllegalArgumentException e) {
            throw new DateTimeException(e.getLocalizedMessage(), null, 2, null);
        }
    }

    @NotNull
    public final Timestamp parseTimestamp(@NotNull String timestampString) {
        Intrinsics.checkNotNullParameter((Object)timestampString, (String)"timestampString");
        Matcher matcher = TIMESTAMP_PATTERN.matcher(timestampString);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"TIMESTAMP_PATTERN.matcher(timestampString)");
        Matcher matcher2 = matcher;
        if (!matcher2.matches()) {
            throw new DateTimeException("Expected TIMESTAMP Format should be in YYYY-MM-DD[\\s|T]hh:mm:ss.ddd+[hh:mm|z], received " + timestampString, null, 2, null);
        }
        String string = matcher2.group("date");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group(\"date\")");
        Date date = this.parseDateLiteral$partiql_parser(string);
        String string2 = matcher2.group("time");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matcher.group(\"time\")");
        Time time = this.parseTimeLiteral$partiql_parser(string2);
        return DateTimeValue.INSTANCE.timestamp(date, time);
    }

    private final TimeZone getTimeZoneComponent(String timezone) {
        String string = timezone.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        char tzSign = StringsKt.first((CharSequence)string);
        String string2 = timezone.substring(1, 3);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        int tzHour = Integer.parseInt(string2);
        String string3 = timezone.substring(4, 6);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        int tzMinute = Integer.parseInt(string3);
        return tzSign == '-' && tzHour == 0 && tzMinute == 0 ? (TimeZone)TimeZone.UnknownTimeZone.INSTANCE : (tzSign == '-' ? (TimeZone)TimeZone.UtcOffset.Companion.of(-tzHour, -tzMinute) : (TimeZone)TimeZone.UtcOffset.Companion.of(tzHour, tzMinute));
    }

    static {
        Pattern pattern = Pattern.compile("(?<year>\\d{4,})-(?<month>\\d{2,})-(?<day>\\d{2,})");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"(?<year>\\\\d{4,}\u2026\\d{2,})-(?<day>\\\\d{2,})\")");
        DATE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("(?<hour>\\d{2,}):(?<minute>\\d{2,}):(?<second>\\d{2,})(?:\\.(?<fraction>\\d+))?\\s*(?<timezone>([+-]\\d\\d:\\d\\d)|(?<utc>[Zz]))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"(?<hour>\\\\d{2,}\u2026:\\\\d\\\\d)|(?<utc>[Zz]))?\")");
        TIME_PATTERN = pattern2;
        SQL_TIMESTAMP_DATE_TIME_DELIMITER = new Regex("\\s+");
        RFC8889_TIMESTAMP_DATE_TIME_DELIMITER = new Regex("[Tt]");
        TIMESTAMP_PATTERN = new Regex("(?<date>" + DATE_PATTERN + ")(" + SQL_TIMESTAMP_DATE_TIME_DELIMITER + '|' + RFC8889_TIMESTAMP_DATE_TIME_DELIMITER + ")(?<time>" + TIME_PATTERN + ')').toPattern();
    }
}

