/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.exception.net;

import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang.StringUtils;

public final class SocketExceptionHelper {
    private SocketExceptionHelper() {
    }

    public static NoRouteToHostException getBetterNoRouteToHostException(NoRouteToHostException e, URLConnection connection) {
        String msg = e.getMessage();
        URL url = connection.getURL();
        msg = "No route to host".equalsIgnoreCase(msg) ? "No route to " + url.getHost() : String.valueOf(msg) + " (" + url.getHost() + ")";
        return new NoRouteToHostException(msg);
    }

    public static NoRouteToHostException getBetterNoRouteToHostException(NoRouteToHostException ex, String host, int port) {
        String msg = ex.getMessage();
        if (msg.contains(host)) {
            return ex;
        }
        msg = "No route to host".equalsIgnoreCase(msg) ? "No route to " + host + ":" + port : String.valueOf(msg) + " (" + host + ":" + port + ")";
        return new NoRouteToHostException(msg);
    }

    public static ConnectException getBetterConnectException(ConnectException ex, String host, int port) {
        String msg = ex.getMessage();
        if (msg.contains(host)) {
            return ex;
        }
        msg = "Connection refused".equalsIgnoreCase(msg) ? "Connection to " + host + ":" + port + " refused" : String.valueOf(msg) + " (" + host + ":" + port + ")";
        return new ConnectException(msg);
    }

    public static SocketException getBetterSocketException(SocketException e, URLConnection connection) {
        URL url;
        String host;
        String msg = e.getMessage();
        if (StringUtils.contains((String)msg, (String)(host = (url = connection.getURL()).getHost()))) {
            return e;
        }
        String betterMsg = String.valueOf(msg) + " (can't connect " + host + ")";
        return new SocketException(betterMsg);
    }
}

