/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.io;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.util.Converter;

public class Resource {
    private static final Logger LOG = LogManager.getLogger(Resource.class);
    private final URI uri;

    public Resource(URI uri) {
        this.uri = uri;
    }

    public Date getModificationDate() throws IOException {
        String scheme = this.uri.getScheme();
        if ("file".equalsIgnoreCase(scheme)) {
            File file = new File(this.uri);
            return new Date(file.lastModified());
        }
        if ("jar".equalsIgnoreCase(scheme)) {
            return Resource.getModificationTimeOf(Converter.toFile(this.uri));
        }
        LOG.warn("Will return {} as Date for unsupported scheme '{}'.", (Object)new Date(0L), (Object)scheme);
        return new Date(0L);
    }

    private static Date getModificationTimeOf(File jarFile) throws IOException {
        String[] parts = jarFile.toString().split("!");
        JarFile jar = new JarFile(parts[0]);
        String entryName = parts[1];
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        }
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry element = entries.nextElement();
                if (!entryName.equals(element.getName())) continue;
                Date date = new Date(element.getTime());
                return date;
            }
            LOG.info("Will return {} as Date for missing entry '{}' in {}.", (Object)new Date(0L), (Object)entryName, (Object)jar);
            Date date = new Date(0L);
            return date;
        }
        finally {
            jar.close();
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

