/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.jmx;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.NullConstants;
import patterntesting.runtime.io.Resource;
import patterntesting.runtime.jmx.InfoMBean;
import patterntesting.runtime.jmx.MBeanHelper;
import patterntesting.runtime.monitor.ClasspathMonitor;

public class Info
implements InfoMBean {
    private static final Logger LOG = LogManager.getLogger(Info.class);
    private static final String MANIFEST_URI = "Manifest-URI";
    private final Properties properties;
    private final Manifest manifest;
    public static final Info PATTERNTESTING = new Info();

    static {
        MBeanHelper.registerMBean("patterntesting.runtime:name=Info", (Object)PATTERNTESTING);
    }

    public Info() {
        this(Info.class);
    }

    public Info(Class<?> clazz) {
        this.properties = Info.loadProperties(clazz);
        this.manifest = Info.getManifest(clazz);
    }

    private static Properties loadProperties(Class<?> clazz) {
        Properties properties = new Properties();
        InputStream istream = clazz.getResourceAsStream("info.properties");
        try {
            try {
                if (istream == null) {
                    throw new IOException("no info.properties found for " + clazz);
                }
                LOG.debug("Read info.properties for {}.", clazz);
                properties.load(istream);
            }
            catch (IOException ioe) {
                LOG.warn("Cannot read info.properties for {}:", clazz, (Object)ioe);
                properties.put("project.version", clazz.getPackage().getImplementationVersion());
                IOUtils.closeQuietly((InputStream)istream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)istream);
        }
        return properties;
    }

    private static Manifest getManifest(Class<?> clazz) {
        ClasspathMonitor cpmon = ClasspathMonitor.getInstance();
        String clazzURI = cpmon.whichClassPath(clazz).toString();
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            LOG.warn("Will return emtpy MANIFEST because got no classloader for {}.", clazz);
            return new Manifest();
        }
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URI uri = resources.nextElement().toURI();
                String path = uri.toString();
                if (path.startsWith(clazzURI)) {
                    return Info.getManifest(uri);
                }
                LOG.trace("{} does not match {} for {}.", (Object)uri, (Object)clazzURI, clazz);
            }
        }
        catch (IOException | URISyntaxException ex) {
            LOG.warn("Cannot read MANIFEST for {}:", clazz, (Object)ex);
        }
        LOG.error("No MANIFEST for {} found, will use first one as fallback.", clazz);
        return Info.getFirstManifest(clazz);
    }

    private static Manifest getFirstManifest(Class<?> clazz) {
        try {
            URI uri = clazz.getClassLoader().getResource("META-INF/MANIFEST.MF").toURI();
            LOG.trace("Found {} as first MANIFEST of {}.", (Object)uri, clazz);
            return Info.getManifest(uri);
        }
        catch (IOException | URISyntaxException ex) {
            LOG.warn("Will return empty MANIFEST because cannot read first one for {}:", clazz, (Object)ex);
            return new Manifest();
        }
    }

    private static Manifest getManifest(URI uri) throws IOException {
        String content = IOUtils.toString((URI)uri, (Charset)StandardCharsets.UTF_8);
        try (ByteArrayInputStream istream = new ByteArrayInputStream(content.getBytes("UTF8"));){
            Manifest manifest = new Manifest(istream);
            manifest.read(istream);
            manifest.getMainAttributes().putValue(MANIFEST_URI, uri.toString());
            Manifest manifest2 = manifest;
            return manifest2;
        }
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public URI getManifestURI() {
        return URI.create(this.manifest.getMainAttributes().getValue(MANIFEST_URI));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public SortedMap<String, String> getInfos() {
        TreeMap<Object, Object> sortedProps;
        TreeMap<Object, Object> infos = sortedProps = new TreeMap<Object, Object>(this.properties);
        Info.addAttributesTo(infos, this.manifest.getMainAttributes());
        return infos;
    }

    private static void addAttributesTo(SortedMap<String, String> infos, Attributes attributes) {
        for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
            infos.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    @Override
    public String getVersion() {
        return this.properties.getProperty("project.version", "unknown");
    }

    @Override
    public Date getBuildTime() {
        Resource resource = new Resource(this.getManifestURI());
        try {
            return resource.getModificationDate();
        }
        catch (IOException ioe) {
            LOG.info("Will return {} because cannot get build time:", (Object)NullConstants.NULL_DATE, (Object)ioe);
            return NullConstants.NULL_DATE;
        }
    }
}

