/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.junit.CollectionTester;
import patterntesting.runtime.util.Converter;

public final class ArrayTester {
    private static final Logger LOG = LogManager.getLogger(ArrayTester.class);

    private ArrayTester() {
    }

    public static void assertEquals(Object[] a1, Object[] a2) {
        CollectionTester.assertEquals(Arrays.asList(a1), Arrays.asList(a2));
    }

    public static void assertEquals(byte[] a1, byte[] a2) {
        if (a1.length != a2.length) {
            LOG.debug("Arrays have different lengths ({} != {}).", (Object)a1.length, (Object)a2.length);
            throw new AssertionError((Object)("arrays have different lengths (" + a1.length + " != " + a2.length + ")"));
        }
        int i = 0;
        while (i < a1.length) {
            ArrayTester.assertEquals(a1, a2, i);
            ++i;
        }
    }

    private static void assertEquals(byte[] a1, byte[] a2, int i) {
        if (a1[i] != a2[i]) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}. element differs ({} != {}).", (Object)(i + 1), (Object)Converter.toLongString(a1[i]), (Object)Converter.toLongString(a2[i]));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{}. element differs ({} != {}).", (Object)(i + 1), (Object)Converter.toString(a1[i]), (Object)Converter.toString(a2[i]));
            }
            throw new AssertionError((Object)(String.valueOf(i + 1) + ". element differs (" + Converter.toShortString(a1[i]) + " != " + Converter.toShortString(a2[i]) + ")"));
        }
    }
}

