/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import patterntesting.runtime.exception.DetailedAssertionError;
import patterntesting.runtime.junit.AbstractTester;
import patterntesting.runtime.junit.internal.XrayClassLoader;

public class ClassTester
extends AbstractTester {
    private static final Logger LOG = LogManager.getLogger(ClassTester.class);
    private static final ClassTester INSTANCE = new ClassTester();
    private final Class<?> clazz;
    private final XrayClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<XrayClassLoader>(){

        @Override
        public XrayClassLoader run() {
            return new XrayClassLoader();
        }
    });

    private ClassTester() {
        this.clazz = this.getClass();
    }

    public ClassTester(String classname) throws ClassNotFoundException {
        this.clazz = this.classLoader.loadClass(classname);
        if (this.clazz == null) {
            throw new ClassNotFoundException(classname);
        }
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public Set<Class<?>> getDependencies() {
        this.clazz.getDeclaredAnnotations();
        this.clazz.getDeclaredClasses();
        this.clazz.getInterfaces();
        this.clazz.getDeclaredConstructors();
        this.clazz.getDeclaredFields();
        this.clazz.getDeclaredMethods();
        return this.classLoader.getLoadedClasses();
    }

    public boolean dependsOn(Class<?> otherClass) {
        return this.dependsOn(otherClass.getName());
    }

    public boolean dependsOn(String otherClassname) {
        Set<Class<?>> dependencies = this.getDependencies();
        for (Class<?> cl : dependencies) {
            if (!otherClassname.equals(cl.getName())) continue;
            return true;
        }
        return false;
    }

    public static Set<Class<?>> getDependenciesOf(String classname) throws ClassNotFoundException {
        return new ClassTester(classname).getDependencies();
    }

    public static boolean dependsOn(String classname, Class<?> otherClass) throws ClassNotFoundException {
        return new ClassTester(classname).dependsOn(otherClass);
    }

    public static void tryStaticInitializer(String classname) throws ClassNotFoundException {
        try {
            INSTANCE.load(classname);
        }
        catch (ExceptionInInitializerError ex) {
            throw new DetailedAssertionError((Object)("cannot initialize class " + classname), (Throwable)ex);
        }
        catch (NoClassDefFoundError ex) {
            throw new DetailedAssertionError((Object)("cannot find class definition of " + classname), (Throwable)ex);
        }
        catch (IllegalAccessError ex) {
            LOG.warn("Cannot access {}:", (Object)classname, (Object)ex);
        }
    }

    private void load(String classname) throws ClassNotFoundException {
        Class<?> loaded = Class.forName(classname);
        Assert.assertEquals((Object)classname, (Object)loaded.getName());
        LOG.trace("{} was loaded by name.", loaded);
        ClassTester.loadClassWith(Thread.currentThread().getContextClassLoader(), classname);
        ClassTester.loadClassWith(this.classLoader, classname);
    }

    private static void loadClassWith(ClassLoader classloader, String classname) throws ClassNotFoundException {
        Class<?> initialized = Class.forName(classname, true, classloader);
        Assert.assertEquals((Object)initialized.getName(), (Object)classname);
        LOG.trace("{} was loaded and initialized by {}.", initialized, (Object)classloader);
        Class<?> loaded = classloader.loadClass(classname);
        Assert.assertEquals(initialized, loaded);
    }
}

