/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.exception.DetailedAssertionError;
import patterntesting.runtime.junit.AbstractTester;
import patterntesting.runtime.junit.ObjectTester;
import patterntesting.runtime.monitor.ClasspathMonitor;
import patterntesting.runtime.util.Converter;

public final class CloneableTester
extends AbstractTester {
    private static final Logger LOG = LogManager.getLogger(CloneableTester.class);
    private static final ClasspathMonitor classpathMonitor = ClasspathMonitor.getInstance();

    private CloneableTester() {
    }

    public static void assertCloning(Class<? extends Cloneable> clazz) {
        try {
            CloneableTester.assertCloning(clazz.newInstance());
        }
        catch (InstantiationException e) {
            throw new DetailedAssertionError((Object)("can't instantiate " + clazz), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DetailedAssertionError((Object)("can't access " + clazz), (Throwable)e);
        }
    }

    public static void assertCloning(Cloneable orig) {
        Cloneable clone = CloneableTester.getCloneOf(orig);
        if (ObjectTester.hasEqualsDeclared(orig.getClass())) {
            ObjectTester.assertEquals(orig, clone);
        }
        if (!orig.getClass().equals(clone.getClass())) {
            throw new AssertionError((Object)(String.valueOf(orig.getClass().getName()) + ".clone() creates another type: " + clone.getClass().getSimpleName()));
        }
    }

    public static Cloneable getCloneOf(Cloneable orig) throws AssertionError {
        Class<?> cloneClass = orig.getClass();
        try {
            Method cloneMethod = cloneClass.getMethod("clone", new Class[0]);
            Cloneable clone = (Cloneable)cloneMethod.invoke((Object)orig, new Object[0]);
            if (clone == orig) {
                throw new AssertionError((Object)(clone + " must have another reference as original object"));
            }
            return clone;
        }
        catch (ReflectiveOperationException ex) {
            if (CloneableTester.hasCloneMethod(cloneClass)) {
                throw new DetailedAssertionError((Object)("clone() is not public in " + cloneClass), (Throwable)ex);
            }
            throw new DetailedAssertionError((Object)("can't invoke clone method found in " + cloneClass), (Throwable)ex);
        }
        catch (SecurityException e) {
            throw new DetailedAssertionError((Object)("can't access clone method of " + orig.getClass()), (Throwable)e);
        }
    }

    private static boolean hasCloneMethod(Class<? extends Cloneable> cloneClass) {
        try {
            Method m = cloneClass.getDeclaredMethod("clone", new Class[0]);
            if (LOG.isTraceEnabled()) {
                LOG.trace(m + " found in " + cloneClass);
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            LOG.trace(cloneClass + " has no clone method:", (Throwable)e);
            return false;
        }
    }

    public static void assertCloning(Collection<Class<? extends Cloneable>> classes) {
        for (Class<? extends Cloneable> clazz : classes) {
            CloneableTester.assertCloning(clazz);
        }
    }

    public static void assertCloning(Package pkg) {
        assert (pkg != null);
        CloneableTester.assertCloningOfPackage(pkg.getName());
    }

    public static void assertCloning(Package pkg, Pattern ... excluded) {
        assert (pkg != null);
        CloneableTester.assertCloningOfPackage(pkg.getName(), excluded);
    }

    public static void assertCloningOfPackage(String packageName) {
        assert (packageName != null);
        Collection<Class<? extends Cloneable>> cloneables = CloneableTester.getCloneableClasses(packageName);
        CloneableTester.assertCloning(cloneables);
    }

    public static void assertCloningOfPackage(String packageName, Class<? extends Cloneable> ... excluded) {
        List<Class<Cloneable>> excludedList = Arrays.asList(excluded);
        CloneableTester.assertCloningOfPackage(packageName, excludedList);
    }

    @Deprecated
    public static void assertCloningOfPackage(String packageName, List<Class<Cloneable>> excluded) {
        Collection<Class<? extends Cloneable>> classes = CloneableTester.getCloneableClasses(packageName);
        LOG.debug(excluded + " will be excluded from check.");
        CloneableTester.removeClasses(classes, excluded);
        CloneableTester.assertCloning(classes);
    }

    public static void assertCloningOfPackage(String packageName, Pattern ... excluded) {
        Collection<Class<? extends Cloneable>> classes = CloneableTester.getCloneableClasses(packageName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pattern {} will be excluded from check.", (Object)Converter.toShortString(excluded));
        }
        CloneableTester.removeClasses(classes, excluded);
        CloneableTester.assertCloning(classes);
    }

    private static Collection<Class<? extends Cloneable>> getCloneableClasses(String packageName) {
        return classpathMonitor.getClassList(packageName, Cloneable.class);
    }
}

