/*
 * Decompiled with CFR 0.152.
 */
package patterntesting.runtime.junit;

import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import patterntesting.runtime.util.Converter;

public final class CollectionTester {
    private static final Logger LOG = LogManager.getLogger(CollectionTester.class);

    private CollectionTester() {
    }

    public static void assertEquals(Collection<?> c1, Collection<?> c2) {
        CollectionTester.assertEquals(c1, c2, "collections differs");
    }

    protected static void assertEquals(Collection<?> c1, Collection<?> c2, String msg) {
        if (c1.size() < c2.size()) {
            CollectionTester.assertEquals(c2, c1);
        } else {
            CollectionTester.assertEqualsSize(c1, c2);
            for (Object elem1 : c1) {
                if (c2.contains(elem1)) continue;
                CollectionTester.logMissingElement(elem1, c2, msg);
                throw new AssertionError((Object)(String.valueOf(msg) + ": [" + Converter.toShortString(elem1) + "] is not in " + Converter.toShortString(c2)));
            }
        }
    }

    private static void logMissingElement(Object element, Collection<?> collection, String msg) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: [{}] is not in {}.", (Object)msg, (Object)Converter.toLongString(element), (Object)Converter.toLongString(collection));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("{}: [{}] is not in {}.", (Object)msg, (Object)Converter.toString(element), (Object)Converter.toString(collection));
        }
    }

    public static void assertEquals(List<?> l1, List<?> l2) {
        if (l1.size() < l2.size()) {
            CollectionTester.assertEquals(l2, l1);
        } else {
            CollectionTester.assertEqualsSize(l1, l2);
            int i = 0;
            while (i < l1.size()) {
                Object elem2;
                Object elem1 = l1.get(i);
                if (!elem1.equals(elem2 = l2.get(i))) {
                    CollectionTester.logDifferentElements(i, elem1, elem2);
                    throw new AssertionError((Object)(String.valueOf(i + 1) + ". element differs (" + Converter.toShortString(elem1) + " != " + Converter.toShortString(elem2) + ")"));
                }
                ++i;
            }
        }
    }

    private static void logDifferentElements(int i, Object elem1, Object elem2) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}. element differs ({} != {}).", (Object)(i + 1), (Object)Converter.toLongString(elem1), (Object)Converter.toLongString(elem2));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("{}. element differs ({} != {}).", (Object)(i + 1), (Object)Converter.toString(elem1), (Object)Converter.toString(elem2));
        }
    }

    private static void assertEqualsSize(Collection<?> c1, Collection<?> c2) throws AssertionError {
        if (c1.size() > c2.size()) {
            for (Object element : c1) {
                if (c2.contains(element)) continue;
                CollectionTester.logMissingElement(element, c2);
                throw new AssertionError((Object)("\"" + Converter.toShortString(element) + "\" is missing in one collection (size: " + c1.size() + " / " + c2.size() + " elements)"));
            }
        }
    }

    private static void logMissingElement(Object element, Collection<?> collection) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Element \"{}\" is missing in {}.", (Object)Converter.toLongString(element), (Object)Converter.toLongString(collection));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Element \"{}\" is missing in {}.", (Object)Converter.toString(element), (Object)Converter.toString(collection));
        }
    }
}

